var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
  },
  data() {
    return {
      VarMenuPage: "admin_users",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],
      selectedItem: 1,
      list: [],

      addUserInfo: {
        show: false, // 新增/編輯使用者版面顯示
        showAddBtn: false, // 新增使用者按鈕
        showEditBtn: false, // 編輯使用者按鈕
        showDeleteBtn: false, // 刪除使用者按鈕

        editUserDisable: false, // 編輯那些資料不能更新設定

        multiple: true, // Select多選功能
        userID: null, // 使用者ID
        name: null, // 使用者名稱
        password: null, // 使用者密碼
        checkPassword: null, // 使用者二次確認輸入密碼
        email: null, // 電子郵件
        telephone: null, // 電話號碼
        cellphone: null, // 手機號碼

        role: {
          // role_id
          value: [],
          options: [],
        },
        roleStationSpec: {
          // role_station_spec
          value: ["all_stn"],
          options: [],
        },

        priv_no: 0,
        enabled: false,
        hide_password: null,
        hide_checkPassword: null,
      },
    };
  },
  computed: {
    columns() {
      // 為了配合多國語系, columns 需使用 computed
      return [
        {
          name: "user_id",
          required: true,
          label: this.$t("page.admin_users.columns.user_id"),
          align: "left",
          field: "user_id",
          sortable: true,
          style: "width: 100px",
        },
        {
          name: "user_name",
          required: true,
          label: this.$t("page.admin_users.columns.name"),
          align: "left",
          field: "user_name",
          sortable: true,
          style: "width: 100px",
        },
        {
          name: "user_role",
          required: true,
          label: this.$t("page.admin_users.columns.user_role"),
          align: "left",
          field: "user_role",
          sortable: true,
          style: "width: 100px",
        },
      ];
    },
    //使用者編輯功能開啟與否判斷
    edit_cheak() {
      return this.$root.FnChkPageFunction("edit");
    },
    //新增使用者功能開啟與否判斷
    add_cheak() {
      return this.$root.FnChkPageFunction("add");
    },

    message_alart() {
      return [
        { label: "未輸入帳號", value: this.$t("page.admin_users.message.id") },
        {
          label: "未輸入密碼",
          value: this.$t("page.admin_users.message.password"),
        },
        {
          label: "未輸入確認密碼",
          value: this.$t("page.admin_users.message.checkPassword"),
        },
        {
          label: "兩個密碼不一致，請輸入正確",
          value: this.$t("page.admin_users.message.password_dc"),
        },
        {
          label: "未輸入姓名",
          value: this.$t("page.admin_users.message.name"),
        },
        {
          label: "電話號碼格式不正確",
          value: this.$t("page.admin_users.message.telephone"),
        },
        {
          label: "手機號碼格式不正確",
          value: this.$t("page.admin_users.message.cellphone"),
        },
        {
          label: "電子郵件格式不正確",
          value: this.$t("page.admin_users.message.email"),
        },
        {
          label: "未選擇角色",
          value: this.$t("page.admin_users.message.norole"),
        },
        {
          label: "新增成功",
          value: this.$t("page.admin_users.message.success"),
        },
        {
          label: "新增失敗",
          value: this.$t("page.admin_users.message.success_error"),
        },
        {
          label: "刪除成功",
          value: this.$t("page.admin_users.message.delete"),
        },
        {
          label: "刪除失敗",
          value: this.$t("page.admin_users.message.delete_error"),
        },
        {
          label: "更新成功",
          value: this.$t("page.admin_users.message.update"),
        },
        {
          label: "更新失敗",
          value: this.$t("page.admin_users.message.update_error"),
        },
        { label: "提醒", value: this.$t("page.admin_users.message.alart") },
        {
          label: "確定刪除此使用者？",
          value: this.$t("page.admin_users.message.delete_user"),
        },
      ];
    },
  },

  watch: {},

  mounted() {
    this.getData();
  },

  methods: {
    getData() {
      let that = this;
      var params = {
        Action: "Users",
        Datas: {},
      };
      return that.FnWebAPIGet(params).then((res) => {
        if (res.data.result) {
          var resData = res.data.data;
          that.tableData = resData;
        } else {
          that.FnNotify(res.data.message, "error");
        }
      });
    },
    searchOk() {
      this.getData();
    },

    //	開啟新增畫面
    addUser() {
      let that = this;
      that.$q.loading.show();
      that.addUserInfo["show"] = true;
      that.addUserInfo["showEditBtn"] = false;
      that.addUserInfo["showDeleteBtn"] = false;
      that.addUserInfo["showAddBtn"] = true;
      that.addUserInfo["editUserDisable"] = false;
      that.addUserInfo["userID"] = null;
      that.addUserInfo["name"] = null;
      that.addUserInfo["password"] = null;
      that.addUserInfo["checkPassword"] = null;
      that.addUserInfo["email"] = null;
      that.addUserInfo["telephone"] = null;
      that.addUserInfo["cellphone"] = null;
      that.addUserInfo["role"]["value"] = [];

      var param = {
        Action: "AddUserInfoLoadingOptios",
        Datas: {},
      };
      that
        .FnWebAPIGet(param)
        .then(function (res) {
          // 角色清單
          var rolesOptios = res.data.data.roles_opt;
          var rolesOptios_len = rolesOptios.length;
          var newRolesOptions = [];
          for (i = 0; i < rolesOptios_len; i++) {
            newRolesOptions.push({ value: "", label: "" });
          }
          that.$set(that.addUserInfo["role"], "options", newRolesOptions);
          for (i = 0; i < rolesOptios_len; i++) {
            that.$set(
              that.addUserInfo["role"]["options"][i],
              "value",
              rolesOptios[i].role_id
            );
            that.$set(
              that.addUserInfo["role"]["options"][i],
              "label",
              rolesOptios[i].role_name
            );
          }
          that.$q.loading.hide();
        })
        .catch(async function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },

    //	儲存新增使用者資訊
    async saveAddUser() {
      let that = this;
      var check = "ok";

      //	帳號確認
      if (
        that.addUserInfo["userID"] == null ||
        that.addUserInfo["userID"] == ""
      ) {
        that.FnNotify(that.message_alart[0]["value"], "error");
        return;
      }
      //	密碼確認
      if (
        that.addUserInfo["password"] == null ||
        that.addUserInfo["password"] == ""
      ) {
        that.FnNotify(that.message_alart[1]["value"], "error");
        return;
      }
      //	第二次密碼確認
      if (
        that.addUserInfo["checkPassword"] == null ||
        that.addUserInfo["checkPassword"] == ""
      ) {
        that.FnNotify(that.message_alart[2]["value"], "error");
        return;
      }
      //	密碼與第二次輸入密碼是否一致
      if (that.addUserInfo["password"] != that.addUserInfo["checkPassword"]) {
        that.FnNotify(that.message_alart[3]["value"], "error");
        return;
      }
      //	姓名確認
      if (that.addUserInfo["name"] == null || that.addUserInfo["name"] == "") {
        that.FnNotify(that.message_alart[4]["value"], "error");
        return;
      }
      //	角色確認
      if (that.addUserInfo["role"]["value"].length == 0) {
        that.FnNotify(that.message_alart[8]["value"], "error");
        return;
      }

      var formData = new FormData();
      formData.append("Action", "AddUserInfo");
      formData.append("Datas", JSON.stringify(that.addUserInfo));

      that.$q.loading.show();
      await that
        .FnWebAPIPost(formData)
        .then(function (res) {
          let result = res.data.result;
          if (result) {
            that.FnNotify(that.message_alart[9]["value"], "success");
            that.getData();
            that.addUserInfo["show"] = false;
            that.$q.loading.hide();
          } else {
            that.FnNotify(that.message_alart[10]["value"], "error");
            that.getData();
            that.addUserInfo["show"] = true;
            that.$q.loading.hide();
          }
        })
        .catch(async function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },

    //	取消新增使用者資訊
    cancelAddUser() {
      let that = this;
      that.addUserInfo["show"] = false;
    },

    // 編輯使用者
    async editUser(rowData) {
      this.addUser();

      let that = this;
      that.$q.loading.show();
      that.addUserInfo["show"] = true;
      that.addUserInfo["showEditBtn"] = true;
      //that.addUserInfo['showDeleteBtn'] = true;
      if (that.LoginSetup["user_name"] == rowData["row"]["user_name"]) {
        that.addUserInfo["showDeleteBtn"] = false;
      } else {
        that.addUserInfo["showDeleteBtn"] = true;
      }
      that.addUserInfo["editUserDisable"] = true;
      that.addUserInfo["showAddBtn"] = false;

      that.addUserInfo["userID"] = null;
      that.addUserInfo["name"] = null;
      that.addUserInfo["password"] = null;
      that.addUserInfo["checkPassword"] = null;
      that.addUserInfo["email"] = null;
      that.addUserInfo["telephone"] = null;
      that.addUserInfo["cellphone"] = null;
      that.addUserInfo["role"]["value"] = [];
      that.addUserInfo["roleStationSpec"]["value"] = [];

      var name = rowData["row"]["user_id"];

      let param = {
        Action: "editUserInfo",
        Datas: {
          user_id: name,
        },
      };
      await that
        .FnWebAPIGet(param)
        .then(function (res) {
          var user_data = res.data.data;
          
          that.$set(that.addUserInfo, "userID", user_data["user_id"]);
          that.$set(that.addUserInfo, "name", user_data["user_name"]);
          that.$set(that.addUserInfo, "email", user_data["email"]);
          if (user_data["enabled"] == "1") {
            that.$set(that.addUserInfo, "enabled", true);
          } else {
            that.$set(that.addUserInfo, "enabled", false);
          }

          if (user_data["role_name"] != null && user_data["role_name"] != "") {
            that.$set(
              that.addUserInfo["role"],
              "value",
              user_data["role_name"].split(",")
            );
          }

          //隱藏密碼
          that.$set(that.addUserInfo, "hide_password", user_data["password"]);
          that.$set(
            that.addUserInfo,
            "hide_checkPassword",
            user_data["password"]
          );

          that.$q.loading.hide();
        })
        .catch(async function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },

    //	更新
    async saveEditUser() {
      let that = this;
      //	密碼確認

      if (that.addUserInfo["password"] != that.addUserInfo["checkPassword"]) {
        that.FnNotify(that.message_alart[3]["value"], "error");
        return;
      }

      //	姓名確認
      if (that.addUserInfo["name"] == null || that.addUserInfo["name"] == "") {
        that.FnNotify(that.message_alart[4]["value"], "error");
        return;
      }

      //	角色確認
      if (that.addUserInfo["role"]["value"].length == 0) {
        that.FnNotify(that.message_alart[8]["value"], "error");
        return;
      }
      var formData = new FormData();
      formData.append("Action", "UpdateUserInfo");
      formData.append("Datas", JSON.stringify(that.addUserInfo));

      that.$q.loading.show();
      await that
        .FnWebAPIPost(formData)
        .then(function (res) {
          let result = res.data.result;
          if (result) {
            that.FnNotify(that.message_alart[13]["value"], "success");
            that.getData();
            that.addUserInfo["show"] = false;
            that.$q.loading.hide();
          } else {
            that.FnNotify(that.message_alart[14]["value"], "error");
            that.getData();
            that.addUserInfo["show"] = true;
            that.$q.loading.hide();
          }
        })
        .catch(async function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },

    //	刪除
    async deleteUser() {
      let that = this;

      if (
        await that.FnConfirm(
          that.message_alart[15]["value"],
          that.message_alart[16]["value"]
        )
      ) {
        var formData = new FormData();
        formData.append("Action", "DeleteUserInfo");
        formData.append("Datas", JSON.stringify(that.addUserInfo));

        that.$q.loading.show();
        await that
          .FnWebAPIPost(formData)
          .then(function (res) {
            let result = res.data.result;
            if (result) {
              that.FnNotify(that.message_alart[11]["value"], "success");
              that.getData();
              that.addUserInfo["show"] = false;
              that.$q.loading.hide();
            } else {
              that.FnNotify(that.message_alart[12]["value"], "error");
              that.getData();
              that.addUserInfo["show"] = false;
              that.$q.loading.hide();
            }
          })
          .catch(async function (err) {
            that.$q.loading.hide();
            console.log(err);
          });
      }
    },
  },
};
