<?php
require_once "../Parameters.php";
require_once "../auth/func.php";

/*
    連線檢查特別版 (祥麟個人使用版本)
    不須寫入資料庫 僅傳送通知用
*/

//設定最大連線間隔時間 單位秒
$n_max_connect_out_time = 900;

$dsn = sprintf("sqlsrv:Server=%s; Database=%s;", $DataSource, $DataBase_Trend);
$pdo_mssql = new PDO($dsn, $UserID, $Password);

//設定連線間隔異常code 請對應ecs_shopee_alarm 資料庫內的store_error_code_list資料表 當前連線狀態異常code = 5
$n_alarm_code = 5;
//查詢錯誤碼資訊
$sql = sprintf(
    "SELECT 
            _secl.error_name
            ,_secl.error_handle
            ,_secl.notify_state
            ,_secl.stop_type
    FROM 	
        [%s].[dbo].[store_error_code_list] AS _secl 
    WHERE
        _secl.error_code = :error_code
    ",
    $DataBase_Alarm
);
//準備執行sql
$sth = $pdo_mssql->prepare($sql);
$sth->execute([
    "error_code" => $n_alarm_code
]);
$row = $sth->fetch(PDO::FETCH_ASSOC);
$s_alarm_name = $row["error_name"];
$s_alarm_handle = $row["error_handle"];

//判斷是否停機 0:不停機 1:停機 ，根據停機與否來更新cashier_state
$n_stop_type = $row["stop_type"];
//cashier_state 當stop_type為0 表示不停機 那此異常訊息為警報類(表示對於現場實際用戶操作影響不大), cashier_state 帶入1
//當stop_type為1 表示停機 那此異常訊息為異常類(表示現場實際用戶已無法完成取貨操作), cashier_state 帶入2
//cashier_state 0:正常 1:警報 2:異常 3:未上線
$n_cashier_state = $n_stop_type == 1 ? 2 : 1;

//撈取所有已綁定的機台 檢查最後一次連線時間與當前時間之時間秒數差異 超過設定最大連線間隔時間值的時候 通知notify
$sql = sprintf(
    "SELECT 
        _s.store_id
        ,_s.store_name
        ,_s.store_open_at
        ,_c.cashier_id 
        ,_c.last_connect_check_at
    FROM 
        [%s].[dbo].[store] AS _s
        LEFT JOIN [%s].[dbo].[cashier] AS _c ON _c.store_id = _s.store_id 
    WHERE
        _c.store_id IS NOT NULL
        AND _s.store_state = 1
    ",
    $DataBase_Trend,
    $DataBase_Trend
);
$sth = $pdo_mssql->prepare($sql);
$sth->execute();
$a_store_data = $sth->fetchAll(PDO::FETCH_ASSOC);

//寫入、更新陣列初始化
$a_inesrt_arr = [];
$a_update_arr = [];
//開始檢查各門市的最後連線時間
foreach ($a_store_data as $k => $v) {
    $check_at = $v["last_connect_check_at"];
    $last_time = empty($check_at) ? 0 : strtotime($check_at);
    $s_store_name = $v["store_name"];
    $s_store_id = $v["store_id"];
    $s_cashier_id = $v["cashier_id"];
    $s_last_check = $last_time == 0 ? "" : date("Y-m-d H:i:s", $last_time);
    $now_time = time();
    //當最後一次連線時間與當前時間超過最大閒置時間時 ， 需通知notify
    if ($now_time - $last_time > $n_max_connect_out_time) {
        // //設定寫入字串 store_alarm_report 表 
        // $sql_insert = "INSERT INTO [$DataBase_Alarm].[dbo].[store_alarm_report](
        //         cashier_id,
        //         store_id,
        //         alarm_code,
        //         alarm_name,
        //         alarm_handle
        //     )
        //     VALUES
        //     (
        //         '$s_cashier_id',
        //         $s_store_id,
        //         $n_alarm_code,
        //         '$s_alarm_name',
        //         '$s_alarm_handle'
        //     )
        // 	";
        // $a_inesrt_arr[] = $sql_insert;
        // //設定更新字串 cashier 表
        // $sql_update = "UPDATE [$DataBase_Trend].[dbo].[cashier]
        //     SET
        //         cashier_state = $n_cashier_state
        //     WHERE
        //         cashier_id = '$s_cashier_id' AND 
        //         store_id = $s_store_id          
        // 	";
        // $a_update_arr[] = $sql_update;
        //line推播
        $a_notify_data = [
            "門市" => $s_store_name,
            "最後連線時間" => $s_last_check,
            "異常代碼" => $n_alarm_code,
            "異常狀況" => $s_alarm_name,
            "對應動作" => $s_alarm_handle,
            "備註" => "",
        ];
        
        //祥麟個人line推播群組 token 
        $custom_token = "HwlDyi1PIaRcZEn06aG74pcs5gSDAvGtgUOCKsbBbOY";
        base_class::line_notify($a_notify_data, $custom_token);
    }
}
//開始寫入資料庫
if (!empty($a_inesrt_arr)) {
    foreach ($a_inesrt_arr as $k => $v) {
        $sth = $pdo_mssql->prepare($v);
        $sth->execute();
    }
}
if (!empty($a_update_arr)) {
    foreach ($a_update_arr as $k => $v) {
        $sth = $pdo_mssql->prepare($v);
        $sth->execute();
    }
}
