var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
  },
  data() {
    return {
      VarMenuPage: "store_transaction_info_list",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],
      isModalOpen: false,
      store: [],
      date_type: [
        { label: "交易完成時間", value: 1 },
        { label: "收款時間", value: 2 }
      ],
      search: {
        store: "1",
        date_type: 1, //查詢時間區間類型 1:依據交易完成時間 2:依據收款時間
        start_date: moment(moment().format("YYYY-MM-DD 00:00:00")).toISOString(),
        end_date: moment(moment().format("YYYY-MM-DD 23:59:00")).toISOString(),
      },
      edit_cash_warn_info: {
        show: false, // 編輯零用金版面顯示
        show_edit_btn: false, // 編輯零用金按鈕
        show_delete_btn: false, // 刪除零用金按鈕

        editUserDisable: false, // 編輯那些資料不能更新設定
        store_id: null, //門市編號
        cash_warning_level: null, // 鈔票警告水位
        cash_stop_level: null, // 鈔票即停水位
        cash_overflow_warning_level: null, // 溢幣區(鈔票)警告水位
        cash_overflow_stop_level: null, // 溢幣區(鈔票)停止水位
        coin_warning_water_level: null, // 硬幣警告水位
        coin_stop_water_level: null, // 硬幣停止水位
        coin_overflow_warning_level: null, // 溢幣區(硬幣)警告水位
        coin_overflow_stop_level: null, // 溢幣區(硬幣)停止水位

        enabled: false,
      },
      excel_name: "TransactionInfo",
    };
  },
  computed: {
    // 為了配合多國語系, columns 需使用 computed
    columns() {
      return [
        {
          name: "transaction_start_time",
          required: true,
          label: this.$t(
            "page.store_transaction_info_list.columns.transaction_start_time"
          ),
          align: "left",
          field: "transaction_start_time",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            var dt = moment(data).format("YYYY-MM-DD HH:mm:ss");
            return dt;
          },
          style: "font-size: 12px;",
        },
        {
          name: "t_start_date",
          label: this.$t(
            "page.store_transaction_info_list.columns.t_start_date"
          ),
          align: "left",
          field: "transaction_start_time",
          $$is_num_format: false,
          $$only_excel: true,
          $$excel_index: 0,
          format: function (data) {
            var dt = moment(data).format("YYYY-MM-DD");
            return dt;
          },
        },
        {
          name: "t_start_time",
          label: this.$t(
            "page.store_transaction_info_list.columns.t_start_time"
          ),
          field: "transaction_start_time",
          $$is_num_format: false,
          $$only_excel: true,
          $$excel_index: 1,
          format: function (data) {
            var dt = moment(data).format("HH:mm:ss");
            return dt;
          },
        },
        {
          name: "t_end_date",
          label: this.$t(
            "page.store_transaction_info_list.columns.t_end_date"
          ),
          field: "transaction_end_time",
          $$is_num_format: false,
          $$only_excel: true,
          $$excel_index: 2,
          format: function (data) {
            var dt = moment(data).format("YYYY-MM-DD");
            return dt;
          },
        },
        {
          name: "t_end_time",
          label: this.$t(
            "page.store_transaction_info_list.columns.t_end_time"
          ),
          field: "transaction_end_time",
          $$is_num_format: false,
          $$only_excel: true,
          $$excel_index: 3,
          format: function (data) {
            var dt = moment(data).format("HH:mm:ss");
            return dt;
          },
        },
        {
          name: "cashier_id",
          label: this.$t(
            "page.store_transaction_info_list.columns.cashier_id"
          ),
          field: "cashier_id",
          $$is_num_format: false,
          $$only_excel: true,
          $$excel_index: 4,
        },
        {
          name: "transaction_end_time",
          required: true,
          label: this.$t(
            "page.store_transaction_info_list.columns.transaction_end_time"
          ),
          align: "left",
          field: "transaction_end_time",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            var dt = moment(data).format("YYYY-MM-DD HH:mm:ss");
            return dt;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "trading_status",
          required: true,
          label: this.$t(
            "page.store_transaction_info_list.columns.trading_status"
          ),
          align: "left",
          field: "trading_status",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 6,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_id",
          required: true,
          label: this.$t("page.store_transaction_info_list.columns.store_id"),
          align: "left",
          field: "store_id",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 11,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_name",
          label: this.$t("page.store_transaction_info_list.columns.store_name"),
          field: "store_name",
          $$only_excel: true,
          $$is_num_format: false,
          $$excel_index: 12,
        },
        {
          name: "trading_id",
          required: true,
          label: this.$t("page.store_transaction_info_list.columns.trading_id"),
          align: "left",
          field: "trading_id",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 5,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "received_ledger_id",
          required: true,
          label: this.$t(
            "page.store_transaction_info_list.columns.received_ledger_id"
          ),
          align: "left",
          field: "received_ledger_id",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 7,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "received_date",
          required: true,
          label: this.$t(
            "page.store_transaction_info_list.columns.received_date"
          ),
          align: "left",
          field: "received_datetime",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 8,
          format: function (data) {
            var dt = "";
            if (data != null) {
              dt = moment(data).format("YYYY-MM-DD");
            }
            return dt;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "received_time",
          required: true,
          label: this.$t(
            "page.store_transaction_info_list.columns.received_time"
          ),
          align: "left",
          field: "received_datetime",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 9,
          format: function (data) {
            var dt = "";
            if (data != null) {
              dt = moment(data).format("HH:mm:ss");
            }
            return dt;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "shopee_shipment_id",
          required: true,
          label: this.$t(
            "page.store_transaction_info_list.columns.shopee_shipment_id"
          ),
          align: "left",
          field: "shopee_shipment_id",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 10,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "payment_type",
          required: true,
          label: this.$t(
            "page.store_transaction_info_list.columns.payment_type"
          ),
          align: "left",
          field: "payment_type",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 13,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "order_amount",
          required: true,
          label: this.$t(
            "page.store_transaction_info_list.columns.order_amount"
          ),
          align: "left",
          field: "order_amount",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 14,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_1000",
          required: true,
          label: this.$t("page.store_transaction_info_list.columns.cash_1000"),
          align: "left",
          field: "cash_1000",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 15,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_500",
          required: true,
          label: this.$t("page.store_transaction_info_list.columns.cash_500"),
          align: "left",
          field: "cash_500",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 16,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_100",
          required: true,
          label: this.$t("page.store_transaction_info_list.columns.cash_100"),
          align: "left",
          field: "cash_100",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 17,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_50",
          required: true,
          label: this.$t("page.store_transaction_info_list.columns.cash_50"),
          align: "left",
          field: "cash_50",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 18,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_10",
          required: true,
          label: this.$t("page.store_transaction_info_list.columns.cash_10"),
          align: "left",
          field: "cash_10",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 19,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_5",
          required: true,
          label: this.$t("page.store_transaction_info_list.columns.cash_5"),
          align: "left",
          field: "cash_5",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 20,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cash_1",
          required: true,
          label: this.$t("page.store_transaction_info_list.columns.cash_1"),
          align: "left",
          field: "cash_1",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 21,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
      ];
    },
    //查詢功能開啟與否判斷
    search_cheak() {
      return this.$root.FnChkPageFunction("search");
    },
    //匯出功能開啟與否判斷
    export_cheak() {
      return this.$root.FnChkPageFunction("export");
    },
    //datetime套件 按鈕名稱定義
    datetime_phrases() {
      let obj = {
        ok: this.$t("sys.ok"),
        cancel: this.$t("sys.cancel"),
      };
      return obj;
    },
    //excel 報表匯出 名稱定義
    excel_name_str() {
      let res = "";
      let store = "";
      let that = this;
      if (this.search.store != 0) {
        this.store.forEach(el => {
          if (el.value == that.search.store) {
            store = `_${el.label}`;
          }
        });
      }
      res = `${this.excel_name}ExportExcel${store}`;
      return res;
    }
  },
  mounted() {
    let that = this;
    that.load_store_option();
    // that.searsh_list();
  },
  methods: {
    // 載入門市下拉選單
    load_store_option() {
      let that = this;
      var params = {
        Action: "StoreOption",
        Datas: {},
        menu_page: "sys_component",
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          _.each(res.data.data, (item) => {
            that.store.push({ label: item.store_name, value: item.store_id });
          });
          that.search.store = _.first(that.store)["value"];
          that.searsh_list();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    searsh_list() {
      let that = this;
      var params = {
        Action: "TransactionList",
        Datas: that.search,
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          that.$set(that, "tableData", res.data.data);
          that.$q.loading.hide();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
  },
};
