var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
  },
  data() {
    return {
      VarMenuPage: "store_transaction_fail_list",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],
      isModalOpen: false,
      store: [],
      date_type: [
        { label: "交易完成時間", value: 1 },
        { label: "收款時間", value: 2 }
      ],
      search: {
        store: "1",
        start_date: moment(moment().format("YYYY-MM-DD 00:00:00")).toISOString(),
        end_date: moment(moment().format("YYYY-MM-DD 23:59:00")).toISOString(),
      },
      transaction_fail_info: {
        show: false, // 編輯零用金版面顯示
        store_id: null, //門市編號
        store_name: null, //門市名稱
        shopee_order_id: null,//蝦皮訂單編號
        shopee_shipment_id: null,//蝦皮出貨任務編號
        //入鈔、入幣紀錄
        //循環機
        cash_1000_in: null,
        cash_500_in: null,
        cash_100_in: null,
        cash_50_in: null,
        cash_10_in: null,
        cash_5_in: null,
        cash_1_in: null,
        //TP70入鈔機
        sub_1000_in: null,
        sub_500_in: null,
        sub_100_in: null,
        //出鈔、出幣紀錄
        //循環機
        cash_500_out: null,
        cash_100_out: null,
        cash_50_out: null,
        cash_10_out: null,
        cash_5_out: null,
        cash_1_out: null,
        //LCDM出鈔機
        sub_500_out: null,
        sub_100_out: null,
      },
      excel_name: "TransactionInfo",
    };
  },
  computed: {
    // 為了配合多國語系, columns 需使用 computed
    columns() {
      return [
        {
          name: "transaction_start_time",
          required: true,
          label: this.$t(
            "page.store_transaction_fail_list.columns.transaction_start_time"
          ),
          align: "left",
          field: "transaction_start_time",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            var dt = moment(data).format("YYYY-MM-DD HH:mm:ss");
            return dt;
          },
          style: "font-size: 12px;",
        },
        {
          name: "t_start_date",
          label: this.$t(
            "page.store_transaction_fail_list.columns.t_start_date"
          ),
          align: "left",
          field: "transaction_start_time",
          $$is_num_format: false,
          $$only_excel: true,
          $$excel_index: 0,
          format: function (data) {
            var dt = moment(data).format("YYYY-MM-DD");
            return dt;
          },
        },
        {
          name: "t_start_time",
          label: this.$t(
            "page.store_transaction_fail_list.columns.t_start_time"
          ),
          field: "transaction_start_time",
          $$is_num_format: false,
          $$only_excel: true,
          $$excel_index: 1,
          format: function (data) {
            var dt = moment(data).format("HH:mm:ss");
            return dt;
          },
        },
        {
          name: "t_end_date",
          label: this.$t(
            "page.store_transaction_fail_list.columns.t_end_date"
          ),
          field: "transaction_end_time",
          $$is_num_format: false,
          $$only_excel: true,
          $$excel_index: 2,
          format: function (data) {
            var dt = moment(data).format("YYYY-MM-DD");
            return dt;
          },
        },
        {
          name: "t_end_time",
          label: this.$t(
            "page.store_transaction_fail_list.columns.t_end_time"
          ),
          field: "transaction_end_time",
          $$is_num_format: false,
          $$only_excel: true,
          $$excel_index: 3,
          format: function (data) {
            var dt = moment(data).format("HH:mm:ss");
            return dt;
          },
        },
        {
          name: "cashier_id",
          label: this.$t(
            "page.store_transaction_fail_list.columns.cashier_id"
          ),
          field: "cashier_id",
          $$is_num_format: false,
          $$only_excel: true,
          $$excel_index: 4,
        },
        {
          name: "transaction_end_time",
          required: true,
          label: this.$t(
            "page.store_transaction_fail_list.columns.transaction_end_time"
          ),
          align: "left",
          field: "transaction_end_time",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            var dt = moment(data).format("YYYY-MM-DD HH:mm:ss");
            return dt;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "trading_status",
          required: true,
          label: this.$t(
            "page.store_transaction_fail_list.columns.trading_status"
          ),
          align: "left",
          field: "trading_status",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 6,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_id",
          required: true,
          label: this.$t("page.store_transaction_fail_list.columns.store_id"),
          align: "left",
          field: "store_id",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 11,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_name",
          label: this.$t("page.store_transaction_fail_list.columns.store_name"),
          field: "store_name",
          $$only_excel: true,
          $$is_num_format: false,
          $$excel_index: 12,
        },
        {
          name: "shopee_order_id",
          required: true,
          label: this.$t("page.store_transaction_fail_list.columns.shopee_order_id"),
          align: "left",
          field: "shopee_order_id",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 5,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "shopee_shipment_id",
          required: true,
          label: this.$t(
            "page.store_transaction_fail_list.columns.shopee_shipment_id"
          ),
          align: "left",
          field: "shopee_shipment_id",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 10,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "order_amount",
          required: true,
          label: this.$t(
            "page.store_transaction_fail_list.columns.order_amount"
          ),
          align: "left",
          field: "order_amount",
          sortable: true,
          $$is_num_format: false,
          $$excel_index: 14,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        }
      ];
    },
    //查詢功能開啟與否判斷
    search_cheak() {
      return this.$root.FnChkPageFunction("search");
    },
    //匯出功能開啟與否判斷
    export_cheak() {
      //如果要開啟匯出功能，要先確認columns 裡面各欄位的excel順序有沒有正確
      return false;
      return this.$root.FnChkPageFunction("export");
    },
    //datetime套件 按鈕名稱定義
    datetime_phrases() {
      let obj = {
        ok: this.$t("sys.ok"),
        cancel: this.$t("sys.cancel"),
      };
      return obj;
    },
    //excel 報表匯出 名稱定義
    excel_name_str() {
      let res = "";
      let store = "";
      let that = this;
      if (this.search.store != 0) {
        this.store.forEach(el => {
          if (el.value == that.search.store) {
            store = `_${el.label}`;
          }
        });
      }
      res = `${this.excel_name}ExportExcel${store}`;
      return res;
    }
  },
  mounted() {
    let that = this;
    that.load_store_option();
    // that.searsh_list();
  },
  methods: {
    // 載入門市下拉選單
    load_store_option() {
      let that = this;
      var params = {
        Action: "StoreOption",
        Datas: {},
        menu_page: "sys_component",
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          _.each(res.data.data, (item) => {
            that.store.push({ label: item.store_name, value: item.store_id });
          });
          that.search.store = _.first(that.store)["value"];
          that.searsh_list();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    searsh_list() {
      let that = this;
      var params = {
        Action: "TransactionList",
        Datas: that.search,
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          that.$set(that, "tableData", res.data.data);
          that.$q.loading.hide();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    //顯示交易失敗資訊
    show_fail_detail(data) {
      let that = this;
      that.transaction_fail_info.show = true

      //門市編號
      that.transaction_fail_info.store_id = data.store_id;
      //門市名稱
      that.transaction_fail_info.store_name = data.store_name;
      //蝦皮訂單編號
      that.transaction_fail_info.shopee_order_id = data.shopee_order_id;
      //蝦皮出貨任務編號
      that.transaction_fail_info.shopee_shipment_id = data.shopee_shipment_id;

      //入鈔、入幣紀錄
      //循環機
      that.transaction_fail_info.cash_1000_in = data.cash_1000_in;
      that.transaction_fail_info.cash_500_in = data.cash_500_in;
      that.transaction_fail_info.cash_100_in = data.cash_100_in;
      that.transaction_fail_info.cash_50_in = data.cash_50_in;
      that.transaction_fail_info.cash_10_in = data.cash_10_in;
      that.transaction_fail_info.cash_5_in = data.cash_5_in;
      that.transaction_fail_info.cash_1_in = data.cash_1_in;
      //TP70入鈔機
      that.transaction_fail_info.sub_1000_in = data.sub_1000_in;
      that.transaction_fail_info.sub_500_in = data.sub_500_in;
      that.transaction_fail_info.sub_100_in = data.sub_100_in;
      //出鈔、出幣紀錄
      //循環機
      that.transaction_fail_info.cash_500_out = data.cash_500_out;
      that.transaction_fail_info.cash_100_out = data.cash_100_out;
      that.transaction_fail_info.cash_50_out = data.cash_50_out;
      that.transaction_fail_info.cash_10_out = data.cash_10_out;
      that.transaction_fail_info.cash_5_out = data.cash_5_out;
      that.transaction_fail_info.cash_1_out = data.cash_1_out;
      //LCDM出鈔機
      that.transaction_fail_info.sub_500_out = data.sub_500_out;
      that.transaction_fail_info.sub_100_out = data.sub_100_out;


    },
    //關閉交易失敗資訊
    close_fail_detail() {
      //清除暫存資料
      this.$data.transaction_fail_info = this.$options.data().transaction_fail_info;
    }
  },
};
