var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
  },
  data() {
    return {
      VarMenuPage: "store_currency_details",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],
      isModalOpen: false,
      store: [],
      search: {
        store: "1",
        start_date: moment(moment().format("YYYY-MM-DD 00:00:00")).toISOString(),
        end_date: moment(moment().format("YYYY-MM-DD 23:59:00")).toISOString(),
      },
    };
  },
  computed: {
    // 為了配合多國語系, columns 需使用 computed
    columns() {
      return [
        {
          name: "store_id",
          required: true,
          label: this.$t(
            "page.store_currency_details.columns.store_id"
          ),
          align: "left",
          field: "store_id",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_name",
          required: true,
          label: this.$t(
            "page.store_currency_details.columns.store_name"
          ),
          align: "left",
          field: "store_name",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "data_create_at",
          required: true,
          label: this.$t("page.store_currency_details.columns.data_create_at"),
          align: "left",
          field: "data_create_at",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            var dt = "";
            if (data != null) {
              dt = moment(data).format("YYYY-MM-DD HH:mm:ss");
            }
            return dt;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "trading_status",
          required: true,
          label: this.$t(
            "page.store_currency_details.columns.trading_status"
          ),
          align: "left",
          field: "trading_status",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        { name: "safe_1000", required: true, label: this.$t("page.store_currency_details.columns.safe_1000"), align: "left", field: "safe_1000", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "safe_500", required: true, label: this.$t("page.store_currency_details.columns.safe_500"), align: "left", field: "safe_500", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "safe_100", required: true, label: this.$t("page.store_currency_details.columns.safe_100"), align: "left", field: "safe_100", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "safe_50", required: true, label: this.$t("page.store_currency_details.columns.safe_50"), align: "left", field: "safe_50", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "safe_10", required: true, label: this.$t("page.store_currency_details.columns.safe_10"), align: "left", field: "safe_10", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "safe_5", required: true, label: this.$t("page.store_currency_details.columns.safe_5"), align: "left", field: "safe_5", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "safe_1", required: true, label: this.$t("page.store_currency_details.columns.safe_1"), align: "left", field: "safe_1", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "cycle_500", required: true, label: this.$t("page.store_currency_details.columns.cycle_500"), align: "left", field: "cycle_500", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "cycle_100", required: true, label: this.$t("page.store_currency_details.columns.cycle_100"), align: "left", field: "cycle_100", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "cycle_50", required: true, label: this.$t("page.store_currency_details.columns.cycle_50"), align: "left", field: "cycle_50", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "cycle_10", required: true, label: this.$t("page.store_currency_details.columns.cycle_10"), align: "left", field: "cycle_10", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "cycle_5", required: true, label: this.$t("page.store_currency_details.columns.cycle_5"), align: "left", field: "cycle_5", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "cycle_1", required: true, label: this.$t("page.store_currency_details.columns.cycle_1"), align: "left", field: "cycle_1", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "sub_in_1000", required: true, label: this.$t("page.store_currency_details.columns.sub_in_1000"), align: "left", field: "sub_in_1000", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "sub_in_500", required: true, label: this.$t("page.store_currency_details.columns.sub_in_500"), align: "left", field: "sub_in_500", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "sub_in_100", required: true, label: this.$t("page.store_currency_details.columns.sub_in_100"), align: "left", field: "sub_in_100", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "sub_out_500", required: true, label: this.$t("page.store_currency_details.columns.sub_out_500"), align: "left", field: "sub_out_500", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
        { name: "sub_out_100", required: true, label: this.$t("page.store_currency_details.columns.sub_out_100"), align: "left", field: "sub_out_100", sortable: true, $$is_num_format: false, $$data_style: "font-size: 14px; padding: 6px;", style: "font-size: 14px; padding: 6px;", },
      ];
    },
    //匯出功能開啟與否判斷
    export_cheak() {
      return this.$root.FnChkPageFunction("export");
    },
    //datetime套件 按鈕名稱定義
    datetime_phrases() {
      let obj = {
        ok: this.$t("sys.ok"),
        cancel: this.$t("sys.cancel"),
      };
      return obj;
    },
    //excel 報表匯出 名稱定義
    excel_name_str() {
      let res = "";
      let store = "";
      let that = this;
      if (this.search.store != 0) {
        this.store.forEach(el => {
          if (el.value == that.search.store) {
            store = `_${el.label}`;
          }
        });
      }
      res = `StoreCurrencyDetailsExportExcel${store}`;
      return res;
    }
  },
  mounted() {
    let that = this;
    that.load_store_option();
  },
  methods: {
    // 載入門市下拉選單
    load_store_option() {
      let that = this;
      var params = {
        Action: "StoreOption",
        Datas: {},
        menu_page: "sys_component",
      };
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          _.each(res.data.data, (item) => {
            that.store.push({ label: item.store_name, value: item.store_id });
          });
          that.search.store = _.first(that.store)["value"];
          that.searsh_list();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    searsh_list() {
      let that = this;
      var params = {
        Action: "CurrencyDetails",
        Datas: that.search,
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          that.$set(that, "tableData", res.data.data);
          that.$q.loading.hide();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
  },
};
