var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
  },
  data() {
    return {
      VarMenuPage: "index",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],
      isModalOpen: false,
      store: [],
      area: [
        { label: "全部", value: 0 },
        { label: "北部", value: 1 },
        { label: "中部", value: 2 },
        { label: "南部", value: 3 },
      ],
      search: {
        store: 0,
        area: 0,
        start_date: moment().format("YYYY/MM/DD"),
        end_date: moment().format("YYYY/MM/DD"),
      },
      table_row_defaul: 50,
      sticky_col: [0, 1],
      excel_name: "store_immediate",
    };
  },

  computed: {
    // 為了配合多國語系, columns 需使用 computed
    columns() {
      return [
        {
          name: "store_id",
          required: true,
          label: this.$t("page.index.columns.store_id"),
          align: "left",
          field: "store_id",
          sortable: true,
          $$sticky: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 0px;",
          style: "font-size: 14px; padding: 0px;",
        },
        {
          name: "store_name",
          required: true,
          label: this.$t("page.index.columns.store_name"),
          align: "left",
          field: "store_name",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_area",
          required: true,
          label: this.$t("page.index.columns.store_area"),
          align: "left",
          field: "store_area",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_open_at",
          required: true,
          label: this.$t("page.index.columns.store_open_at"),
          align: "left",
          field: "store_open_at",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "replenish_date",
          required: true,
          label: this.$t("page.index.columns.replenish_date"),
          align: "left",
          field: "replenish_date",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cashier_state",
          required: true,
          label: this.$t("page.index.columns.cashier_state"),
          align: "left",
          field: "cashier_state",
          sortable: true,
          $$is_num_format: false,
          $$fn_data_style: (row) => {
            let val_style = '';
            switch (row.cashier_state) {
              case '警報':
                val_style = 'color: #f1a14c;';
                break;
              case '異常':
                val_style = 'color: red;';
                break;
            }
            return val_style;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_alarm_code",
          required: true,
          label: this.$t("page.index.columns.store_alarm_code"),
          align: "left",
          field: "store_alarm_code",
          sortable: true,
          $$is_num_format: false,
          $$fn_data_style: (row) => {
            let val_style = '';
            switch (row.cashier_state) {
              case '警報':
                val_style = 'color: #f1a14c;';
                break;
              case '異常':
                val_style = 'color: red;';
                break;
            }
            return val_style;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_alarm_name",
          required: true,
          label: this.$t("page.index.columns.store_alarm_name"),
          align: "left",
          field: "store_alarm_name",
          sortable: true,
          $$is_num_format: false,
          $$fn_data_style: (row) => {
            let val_style = '';
            switch (row.cashier_state) {
              case '警報':
                val_style = 'color: #f1a14c;';
                break;
              case '異常':
                val_style = 'color: red;';
                break;
            }
            return val_style;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_cycle_amount",
          required: true,
          label: this.$t("page.index.columns.total_cycle_amount"),
          align: "left",
          field: "total_cycle_amount",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_cashier_amount",
          required: true,
          label: this.$t("page.index.columns.total_cashier_amount"),
          align: "left",
          field: "total_cashier_amount",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "sub_out_box",
          required: true,
          label: this.$t("page.index.columns.sub_out_box"),
          align: "left",
          field: "sub_out_box",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "sub_in_box",
          required: true,
          label: this.$t("page.index.columns.sub_in_box"),
          align: "left",
          field: "sub_in_box",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "safe_cash_box",
          required: true,
          label: this.$t("page.index.columns.safe_cash_box"),
          align: "left",
          field: "safe_cash_box",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cycle_500",
          required: true,
          label: this.$t("page.index.columns.cycle_500"),
          align: "left",
          field: "cycle_500",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cycle_100",
          required: true,
          label: this.$t("page.index.columns.cycle_100"),
          align: "left",
          field: "cycle_100",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cycle_50",
          required: true,
          label: this.$t("page.index.columns.cycle_50"),
          align: "left",
          field: "cycle_50",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cycle_10",
          required: true,
          label: this.$t("page.index.columns.cycle_10"),
          align: "left",
          field: "cycle_10",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cycle_5",
          required: true,
          label: this.$t("page.index.columns.cycle_5"),
          align: "left",
          field: "cycle_5",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "cycle_1",
          required: true,
          label: this.$t("page.index.columns.cycle_1"),
          align: "left",
          field: "cycle_1",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "safe_coin_box",
          required: true,
          label: this.$t("page.index.columns.safe_coin_box"),
          align: "left",
          field: "safe_coin_box",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
      ];
    },
    //查詢功能開啟與否判斷
    search_cheak() {
      return this.$root.FnChkPageFunction("search");
    },
    //匯出功能開啟與否判斷
    export_cheak() {
      return this.$root.FnChkPageFunction("export");
    },
    //excel 報表匯出 名稱定義
    excel_name_str() {
      let res = "";
      let store = "";
      let that = this;
      if (this.search.store != 0) {
        this.store.forEach(el => {
          if (el.value == that.search.store) {
            store = `_${el.label}`;
          }
        });
      }
      res = `${this.excel_name}ExportExcel${store}`;
      return res;
    }
  },

  watch: {},

  mounted() {
    let that = this;
    let temp_search_data = this.$q.sessionStorage.get.item("index_search");
    if (temp_search_data != undefined) {
      that.search = temp_search_data;
    }
    that.load_store_option();
    // that.searsh_list();
    // 輪巡設定
    setInterval(function () {
      that.searsh_list(true);
    }, 10000);
  },
  methods: {
    // 載入門市下拉選單
    load_store_option() {
      let that = this;
      var params = {
        Action: "StoreOption",
        Datas: {},
        menu_page: "sys_component",
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          _.each(res.data.data, (item) => {
            that.store.push({ label: item.store_name, value: item.store_id });
          });
          that.searsh_list();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    searsh_list(reload = false) {
      this.$q.sessionStorage.set("index_search", this.search);
      let that = this;
      var params = {
        Action: "IndexInfo",
        Datas: that.search,
      };
      if (!reload) {
        that.$q.loading.show();
      }
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          that.$set(that, "tableData", res.data.data);
          that.$q.loading.hide();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
  },
};
