var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
  },
  data() {
    return {
      VarMenuPage: "admin_page_permission_setting",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],

      formPageSet: {
        view: false,
        edit: true,
        update: false,
        role: null,
        tempPageName: [],
        tempSelectUse: [],
      },
      formStoreSet: {
        view: false,
        update: false,
        value: false,
        role: null,
      },
    };
  },
  computed: {
    columns() {
      // 為了配合多國語系, columns 需使用 computed
      return [
        {
          name: "role_name",
          required: true,
          label: this.$t(
            "page.admin_page_permission_setting.columns.role_name"
          ),
          align: "left",
          field: "role_name",
          sortable: true,
          style: "width: 100px",
        },
        {
          name: "view_page",
          required: true,
          label: this.$t(
            "page.admin_page_permission_setting.columns.view_page"
          ),
          align: "left",
          field: "view_page",
          sortable: true,
          style: "width: 100px",
          $$is_slot: true,
        },
        {
          name: "view_store",
          required: true,
          label: this.$t(
            "page.admin_page_permission_setting.columns.view_store"
          ),
          align: "left",
          field: "view_store",
          sortable: true,
          style: "width: 100px",
          $$is_slot: true,
        },
      ];
    },

    //權限設定功能開啟與否判斷
    edit_cheak() {
      return this.$root.FnChkPageFunction("edit");
    },
  },
  mounted() {
    this.getData();
  },

  methods: {
    btnSwitch() {
      let that = this;
      that.formPageSet["edit"] = false;
      that.formPageSet["update"] = true;
    },

    getData() {
      let that = this;
      that.$q.loading.show();
      var params = {
        Action: "Roles",
        Datas: {},
      };
      return that.FnWebAPIGet(params).then((res) => {
        if (res.data.result) {
          var resData = res.data.data;
          that.tableData = resData;
          that.$q.loading.hide();
        } else {
          that.FnNotify(res.data.message, "error");
          that.$q.loading.hide();
        }
      });
    },
    view_store_ctrl(props) {
      let that = this;
      that.formStoreSet["view"] = true;
      that.formStoreSet["update"] = true;
      that.formStoreSet["role"] = props.role_id;
      that.formStoreSet["value"] = props.store_ctrl == 1 ? false : true;
    },
    //	更新門市顯示設定
    update_view_store() {
      this.$q.loading.show();
      let that = this;
      var params = {
        Action: "role_store_view",
        Datas: {
          role: that.formStoreSet["role"],
          store_view: that.formStoreSet.value,
        },
      };
      return that.FnWebAPIPost(params).then((res) => {
        if (res.data.result) {
          that.getData();
          that.formStoreSet["view"] = false;
          that.FnNotify(res.data.message, "success");
        } else {
          that.FnNotify(res.data.message, "error");
        }
        this.$q.loading.hide();
      });
    },

    //	step.1 檢視 撈資料
    viewRoleId(props) {
      this.$q.loading.show();
      let that = this;
      that.formPageSet["tempSelectUse"] = [];
      that.formPageSet["view"] = true;
      that.formPageSet["edit"] = true;
      that.formPageSet["update"] = false;
      that.formPageSet["role"] = props.role_id;
      var params = {
        Action: "MenuLoad",
        Datas: {
          menu: "permissions",
        },
        menu_page: "sys_component",
      };
      return that.FnWebAPIGet(params).then((res) => {
        if (res.data.result) {
          var resData = res.data.data;
          that.formPageSet["tempPageName"] = resData;
          that.viewRoleViewPage();
        } else {
          that.$q.loading.hide();
          that.FnNotify(res.data.message, "error");
        }
      });
    },

    //	step.1-2 檢視之前的紀錄
    viewRoleViewPage() {
      let that = this;
      var params = {
        Action: "Menu",
        Datas: {
          role_id: that.formPageSet["role"],
        },
      };
      return that.FnWebAPIGet(params).then((res) => {
        that.$q.loading.hide();
        if (res.data.result) {
          var resData = res.data.data;
          _.each(resData, (item, idx) => {
            that.formPageSet["tempSelectUse"].push(item);
          });
        } else {
          that.$q.loading.hide();
          that.FnNotify(res.data.message, "error");
        }
      });
    },

    //	step.2 更新角色頁面權限設定
    updateRoleMenu(props) {
      this.$q.loading.show();
      let that = this;
      var params = {
        Action: "RoleMenu",
        Datas: {
          role: that.formPageSet["role"],
          page_arr: that.formPageSet["tempSelectUse"],
        },
      };
      return that.FnWebAPIPost(params).then((res) => {
        if (res.data.result) {
          that.FnNotify(res.data.message, "success");
          that.formPageSet["view"] = false;
        } else {
          that.FnNotify(res.data.message, "error");
        }
        this.$q.loading.hide();
      });
    },

    // 表單checkbox狀態連動判斷
    checkbox_link(inx) {
      let that = this;
      inx = inx.toString();
      let inx_split = inx.split("-");
      let inx_1 = null;
      let inx_2 = null;
      let func = null;
      inx_split.forEach((el, i) => {
        if (i == 0) {
          if (el.includes(".")) {
            func = el.split(".")[1];
            inx_1 = el.split(".")[0];
          } else {
            inx_1 = el;
          }
        } else if (i == 1) {
          if (el.includes(".")) {
            func = el.split(".")[1];
            inx_2 = el.split(".")[0];
          } else {
            inx_2 = el;
          }
        }
      });
      let page_name_1 = that.formPageSet.tempPageName[inx_1].menu_id;
      let page_name_2 =
        inx_2 == null
          ? ""
          : that.formPageSet.tempPageName[inx_1].children[inx_2].menu_id;
      let func_name = "";
      if (func != null) {
        func_name =
          inx_2 == null
            ? that.formPageSet.tempPageName[inx_1].function[func]
            : that.formPageSet.tempPageName[inx_1].children[inx_2].function[
                func
              ];
      }
      let check_menu_id = "";
      if (page_name_2 == "") {
        check_menu_id = page_name_1;
        if (func_name != "") {
          check_menu_id = `${check_menu_id}.${func_name}`;
        }
      } else {
        check_menu_id = page_name_2;
        if (func_name != "") {
          check_menu_id = `${check_menu_id}.${func_name}`;
        }
      }
      let checked_type = that.formPageSet.tempSelectUse.includes(check_menu_id);
      //選中
      if (checked_type) {
        if (
          !that.formPageSet.tempSelectUse.includes(page_name_1) &&
          page_name_1 != ""
        ) {
          that.formPageSet.tempSelectUse.push(page_name_1);
        }
        if (
          !that.formPageSet.tempSelectUse.includes(page_name_2) &&
          page_name_2 != ""
        ) {
          that.formPageSet.tempSelectUse.push(page_name_2);
        }
      }
      //未選
      else {
        //第二層
        if (page_name_2 != "") {
          if (
            that.formPageSet.tempPageName[inx_1].children[inx_2].function !=
              undefined &&
            func_name == ""
          ) {
            that.formPageSet.tempPageName[inx_1].children[
              inx_2
            ].function.forEach((el_func) => {
              that.formPageSet.tempSelectUse =
                that.formPageSet.tempSelectUse.filter(function (item) {
                  return item !== `${page_name_2}.${el_func}`;
                });
            });
          }
        }
        //第一層
        else {
          if (that.formPageSet.tempPageName[inx_1].children != undefined) {
            that.formPageSet.tempPageName[inx_1].children.forEach((el) => {
              if (el.function != undefined) {
                el.function.forEach((el_func) => {
                  that.formPageSet.tempSelectUse =
                    that.formPageSet.tempSelectUse.filter(function (item) {
                      return item !== `${el.menu_id}.${el_func}`;
                    });
                });
              }
              that.formPageSet.tempSelectUse =
                that.formPageSet.tempSelectUse.filter(function (item) {
                  return item !== `${el.menu_id}`;
                });
            });
          }
          if (
            that.formPageSet.tempPageName[inx_1].function != undefined &&
            func_name == ""
          ) {
            that.formPageSet.tempPageName[inx_1].function.forEach((el_func) => {
              that.formPageSet.tempSelectUse =
                that.formPageSet.tempSelectUse.filter(function (item) {
                  return item !== `${page_name_1}.${el_func}`;
                });
            });
          }
        }
      }
    },
  },
};
