/*
  FILE: i18n_messages.js
  在 html_down.php 引入
  usage:
    <div>{{ $t("lbl.hello") }}</div>
    this.$t("lbl.hello")
*/
if ($$i18n_messages == undefined) {
  var $$i18n_messages = {};
}
$$i18n_messages["zh-hant"] = {
  // zh-hant 繁中
  language: "中文",
  sys: {
    version: "版本",
    loading_wait: "正在載入資料，請稍候",
    plz_try_again: "請稍後再試",
    user: "使用者",
    ok: "確定",
    cancel: "取消",
    add: "新增",
    edit: "編輯",
    view: "檢視",
    export: "匯出",
    search: "查詢",
    otp_show: "OTP顯示",
    setting: "設定",
    save: "儲存",
    update: "更新",
    delete: "刪除",
    void: "作廢",
    close: "關閉",
    recovery: "還原",
    default: "預設",
    column: "欄位",
    retaliation: "回報",
    record: "紀錄",
    phase: {
      draft: "草稿",
      execute: "進行",
      completed: "完工",
      complete: "完工",
      end: "結案",
      void: "作廢",
    },
    message: {
      info: "訊息",
      confirm: "確認",
      download_error: "檔案下載出錯",
      connect_error: "連線異常請重新登入",
      are_sure_to_execute: "確定要執行嗎？",
      execute_success: "執行成功",
    },
    weather_location: {
      // 可再此加其它縣市
      city: {
        彰化縣: "彰化縣",
        臺南市: "臺南市",
        臺中市: "臺中市",
      },
      town: {
        伸港鄉: "伸港鄉",
        仁德區: "仁德區",
        大里區: "大里區",
        社頭鄉: "社頭鄉",
        秀水鄉: "秀水鄉",
        永康區: "永康區",
      },
    },
  },
  options: {
    time: {
      all_time: "所有時間",
      ten_min: "十分鐘",
      thirty_min: "三十分鐘",
      one_hour: "一小時",
      one_day: "一日",
    },
    currency: {
      unit: "單位",
      cash_unit: "張",
      coin_unit: "個",
    },
  },
  layout: {
    system_name: "蝦皮雲端系統",
    menu: "選單",
    collapse_menu: "收合選單",
    expand_menu: "展開選單",
    right_menu: "右側選單",
    right_menu_msg: {
      select: "已切換案場",
      noselect: "你選的",
      nocctv: "沒有CCTV",
    },
    nav_menu: {
      home: "首頁",
      station_list: "案場清單",
      back: "上一頁",
    },
    change_password: {
      title: "變更密碼",
      label: {
        user_id: "使用者帳號",
        user_name: "使用者名稱",
        old_pwd: "舊密碼",
        new_pwd1: "新密碼",
        new_pwd2: "確認新密碼",
      },
      msg: {
        new_pwd_empty: "新密碼不可為空白",
        new_pwd_not_same: "新密碼與確認新密碼不相同",
        old_pwd_error: "舊密碼錯誤",
        other_error: "其他錯誤",
        change_pwd_success: "密碼變更成功",
      },
    },
  },
  page: {
    login: {
      system_login: "系統登入",
      account: "帳號",
      password: "密碼",
      login: "登入",
      logout: "登出",
      plz_login_again: "請重新登入",
      login_expire: "登入資料已過期",
      login_failed: "登入失敗",
      verify_failed: "驗證失敗",
    },
    index: {
      index: "各門市即時總覽",
      search: {
        start_date: "開始時間",
        end_date: "結束時間",
        store: "門市",
        area: "區域",
      },
      columns: {
        store_id: "門市編號",
        store_name: "門市名稱",
        store_area: "門市區域",
        store_open_at: "門市開業日期",
        cashier_name: "機台名稱",
        replenish_date: "換補天數",
        cashier_state: "機台狀態",
        store_alarm_code: "異常代碼",
        store_alarm_name: "異常名稱",
        total_cycle_amount: "總零用金",
        total_cashier_amount: "總金額",
        cycle_500: "面額_500",
        cycle_100: "面額_100",
        cycle_50: "面額_50",
        cycle_10: "面額_10",
        cycle_5: "面額_5",
        cycle_1: "面額_1",
        safe_cash_box: "鈔票錢箱",
        sub_out_box: "發鈔錢箱",
        sub_in_box: "副鈔機錢箱",
        safe_coin_box: "硬幣溢幣區",
      },
    },
    store_received_ledger_list: {
      store_received_ledger_list: "收款報表",
      search: {
        start_date: "開始時間",
        end_date: "結束時間",
        store: "門市",
      },
      columns: {
        received_date: "收款日",
        business_date: "營業日",
        store_id: "門市編號",
        store_name: "門市名稱",
        cashier_id: "機器編號",
        received_ledger_id: "收款編號",
        received_date: "收款日",
        received_start_time: "收款開始時間",
        received_end_time: "收款完成時間",
        logistics_amount_total: "總物流金額",
        commodity_amount_total: "總商品金額",
        total_amount: "總金額",
      },
    },
    store_received_statement_list: {
      store_received_statement_list: "收款明細",
      search: {
        start_date: "開始時間",
        end_date: "結束時間",
        store: "門市",
        date_type: "時間範圍依據",
      },
      columns: {
        received_date: "收款日",
        business_date: "營業日",
        store_id: "門市編號",
        store_name: "門市名稱",
        received_ledger_id: "收款編號",
        logistics_amount: "物流金額",
        commodity_amount: "商品金額",
        total_amount: "總金額",
      },
    },
    store_business_list: {
      store_business_list: "營業報表",
      search: {
        start_date: "開始時間",
        end_date: "結束時間",
        store: "門市",
      },
      columns: {
        store_id: "門市編號",
        store_name: "門市名稱",
        cashier_id: "機器編號",
        total_amount: "總金額",
        transaction_date: "交易日",
        order_amount: "總金額",
        cash_1000: "面額_1000",
        cash_500: "面額_500",
        cash_100: "面額_100",
        cash_50: "面額_50",
        cash_10: "面額_10",
        cash_5: "面額_5",
        cash_1: "面額_1",
      },
    },
    store_transaction_statement_list: {
      store_transaction_statement_list: "物流交易明細",
      search: {
        start_date: "開始時間",
        end_date: "結束時間",
        store: "門市",
      },
      columns: {
        store_id: "門市編號",
        store_name: "門市名稱",
        cashier_id: "機器編號",
        t_start_date: "交易開始日期",
        t_start_time: "交易開始時間",
        t_end_date: "交易完成日期",
        t_end_time: "交易完成時間",
        transaction_start_time: "交易開始時間",
        transaction_end_time: "交易完成時間",
        trading_status: "交易狀態",
        trading_id: "交易編號",
        received_ledger_id: "收款編號",
        received_date: "收款日",
        received_time: "收款時間",
        shopee_shipment_id: "蝦皮出貨任務編號",
        shopee_order_id: "蝦皮訂單編號",
        payment_type: "付款方式",
        order_amount: "訂單金額",
      },
    },
    store_transaction_info_list: {
      store_transaction_info_list: "物流交易資料",
      search: {
        start_date: "開始時間",
        end_date: "結束時間",
        store: "門市",
      },
      columns: {
        store_id: "門市編號",
        store_name: "門市名稱",
        cashier_id: "機器編號",
        t_start_date: "交易開始日期",
        t_start_time: "交易開始時間",
        t_end_date: "交易完成日期",
        t_end_time: "交易完成時間",
        transaction_start_time: "交易開始時間",
        transaction_end_time: "交易完成時間",
        trading_status: "交易狀態",
        trading_id: "交易編號",
        received_ledger_id: "收款編號",
        received_date: "收款日",
        received_time: "收款時間",
        shopee_shipment_id: "蝦皮出貨任務編號",
        payment_type: "付款方式",
        order_amount: "總金額",
        cash_1000: "面額_1000",
        cash_500: "面額_500",
        cash_100: "面額_100",
        cash_50: "面額_50",
        cash_10: "面額_10",
        cash_5: "面額_5",
        cash_1: "面額_1",
      },
      message: {
        update_error: "更新失敗",
        update: "更新成功",
      },
    },
    store_transaction_fail_list: {
      store_transaction_info_list: "異常交易紀錄",
      search: {
        start_date: "開始時間",
        end_date: "結束時間",
        store: "門市",
      },
      columns: {
        store_id: "門市編號",
        store_name: "門市名稱",
        cashier_id: "機器編號",
        t_start_date: "交易開始日期",
        t_start_time: "交易開始時間",
        t_end_date: "交易完成日期",
        t_end_time: "交易完成時間",
        transaction_start_time: "交易開始時間",
        transaction_end_time: "交易結束時間",
        trading_status: "交易狀態",
        trading_id: "交易編號",
        received_ledger_id: "收款編號",
        received_date: "收款日",
        received_time: "收款時間",
        shopee_shipment_id: "蝦皮出貨任務編號",
        shopee_order_id: "蝦皮訂單編號",
        payment_type: "付款方式",
        order_amount: "總金額",
        cash_1000: "面額_1000",
        cash_500: "面額_500",
        cash_100: "面額_100",
        cash_50: "面額_50",
        cash_10: "面額_10",
        cash_5: "面額_5",
        cash_1: "面額_1",
      },
      dailog: {
        shopee_shipment_id: "蝦皮出貨任務編號",
        shopee_order_id: "蝦皮訂單編號",
        cash_1000_in: '入鈔-1000',
        cash_500_in: '循環機-入鈔-500',
        cash_100_in: '循環機-入鈔-100',
        cash_50_in: '硬幣循環機-入幣-50',
        cash_10_in: '硬幣循環機-入幣-10',
        cash_5_in: '硬幣循環機-入幣-5',
        cash_1_in: '硬幣循環機-入幣-1',
        sub_100_in: '備用入鈔-100',
        cash_500_out: '循環機-出鈔-500',
        cash_100_out: '循環機-出鈔-100',
        cash_50_out: '硬幣循環機-出幣-50',
        cash_10_out: '硬幣循環機-出幣-10',
        cash_5_out: '硬幣循環機-出幣-5',
        cash_1_out: '硬幣循環機-出幣-1',
        sub_100_out: '備用出鈔-100',
      },
      message: {
        update_error: "更新失敗",
        update: "更新成功",
      },
    },
    store_daily_cash_list: {
      store_daily_cash_list: "門市每日現金資料",
      search: {
        start_date: "開始時間",
        end_date: "結束時間",
        store: "門市",
      },
      columns: {
        cashier_name: "機器名稱",
        store_id: "門市編號",
        store_name: "門市名稱",
        statistics_date: "日期",
        total_1000_in: "入鈔_1000",
        total_500_in: "入鈔_500",
        total_100_in: "入鈔_100",
        total_500_out: "出鈔_500",
        total_100_out: "出鈔_100",
        reject_rate: "拒鈔率",
        cycle_rate: "循環率",
        total_amount: "總金額",
        total_500: "面額_500",
        total_100: "面額_100",
        total_50: "面額_50",
        total_10: "面額_10",
        total_5: "面額_5",
        total_1: "面額_1",
        total_cash_count: "鈔票錢箱數量",
        total_cash_amount: "鈔票錢箱總額",
        total_coin_count: "硬幣溢幣數量",
        total_coin_amount: "硬幣溢幣總額",
      },
      table_data: {
        over_cycle_rate: "換補",
      },
    },
    store_machine_alarm_list: {
      store_machine_alarm_list: "門市機器異常報表",
      search: {
        start_date: "開始時間",
        end_date: "結束時間",
        store: "門市",
      },
      columns: {
        store_id: "門市編號",
        store_name: "門市名稱",
        create_time: "異常時間",
        cashier_name: "機台名稱",
        alarm_code: "異常代碼",
        alarm_name: "異常名稱",
        alarm_note: "備註",
      },
      edit_block: {
        edit_title: "設定零用金",
        petty_cash_500: "面額_500",
        petty_cash_100: "面額_100",
        petty_cash_50: "面額_50",
        petty_cash_10: "面額_10",
        petty_cash_5: "面額_5",
        petty_cash_1: "面額_1",
        total_amount: "總金額",
      },
      message: {
        update_error: "更新失敗",
        update: "更新成功",
      },
    },
    store_currency_details: {
      store_currency_details: "門市貨幣異動明細",
      search: {
        start_date: "開始時間",
        end_date: "結束時間",
        store: "門市",
      },
      columns: {
        store_id: "門市編號",
        store_name: "門市名稱",
        data_create_at: "資料建立時間",
        trading_status: "異動類型",
        safe_1000: "保全箱_1000",
        safe_500: "保全箱_500",
        safe_100: "保全箱_100",
        safe_50: "保全箱_50",
        safe_10: "保全箱_10",
        safe_5: "保全箱_5",
        safe_1: "保全箱_1",
        cycle_500: "循環機_500",
        cycle_100: "循環機_100",
        cycle_50: "循環機_50",
        cycle_10: "循環機_10",
        cycle_5: "循環機_5",
        cycle_1: "循環機_1",
        sub_in_1000: "入鈔機_1000",
        sub_in_500: "入鈔機_500",
        sub_in_100: "入鈔機_100",
        sub_out_500: "出鈔機_500",
        sub_out_100: "出鈔機_100",
      },
      message: {
        update_error: "更新失敗",
        update: "更新成功",
      },
    },

    store_list: {
      store_list: "門市列表",
      search: {
        store: "門市",
      },
      columns: {
        store_id: "門市編號",
        store_name: "門市名稱",
        store_open_at: "門市開業日期",
        binding_cashier: "機台序號",
        store_api_key: "雲端API金鑰",
        create_at: "建立時間",
      },
      store_info_block: {
        add_title: "新增門市",
        edit_title: "設定門市",
        store_open_at: "門市開業日期",
        store_name: "門市名稱",
        store_id: "門市編號",
        store_area: "門市區域",
        store_state: "門市當前狀態",
      },
      table_data: {
        no_binding_cashier: "未綁定機台",
      },
      message: {
        false: "失敗",
        create_error: "新增失敗",
        create: "新增成功",
        update_error: "更新失敗",
        update: "更新成功",
        no_store_id: "未輸入門市編號",
        no_store_name: "未輸入門市名稱",
        no_store_area: "未選擇門市區域",
      },
    },
    store_allowance_setting: {
      store_allowance_setting: "門市零用金設定",
      search: {
        start_date: "開始時間",
        end_date: "結束時間",
        location: "案場",
        alarm_priority: "警報等級",
        equipment: "設備名稱",
        not_returning: "沒有復歸",
        store: "門市",
      },
      columns: {
        store_id: "門市編號",
        store_name: "門市名稱",
        total_amount: "總金額",
        petty_cash_500: "面額_500",
        petty_cash_100: "面額_100",
        petty_cash_50: "面額_50",
        petty_cash_10: "面額_10",
        petty_cash_5: "面額_5",
        petty_cash_1: "面額_1",
      },
      edit_block: {
        store_id: "門市編號",
        store_name: "門市名稱",
        edit_title: "設定零用金",
        petty_cash_500: "面額_500",
        petty_cash_100: "面額_100",
        petty_cash_50: "面額_50",
        petty_cash_10: "面額_10",
        petty_cash_5: "面額_5",
        petty_cash_1: "面額_1",
        total_amount: "總金額",
        max_count: "最大數量",
      },
      message: {
        update_error: "更新失敗",
        update_error_count: "數量設定異常",
        no_select_store: "未選擇門市",
        update: "更新成功",
      },
    },

    store_cash_warn_setting: {
      store_cash_warn_setting: "門市現金警戒設定",
      search: {
        start_date: "開始時間",
        end_date: "結束時間",
        location: "案場",
        alarm_priority: "警報等級",
        equipment: "設備名稱",
        not_returning: "沒有復歸",
        store: "門市",
      },
      columns: {
        store_id: "門市編號",
        store_name: "門市名稱",
        cash_warning_level: "發鈔錢箱警告水位",
        cash_stop_level: "發鈔錢箱即停水位",
        cash_overflow_warning_level: "鈔票錢箱警告水位",
        cash_overflow_stop_level: "鈔票錢箱停止水位",
        coin_warning_water_level: "硬幣警告水位",
        coin_stop_water_level: "硬幣停止水位",
        coin_overflow_warning_level: "溢幣區(硬幣)警告水位",
        coin_overflow_stop_level: "溢幣區(硬幣)停止水位",
      },
      edit_block: {
        store_id: "門市編號",
        store_name: "門市名稱",
        edit_title: "設定警戒水位",
        cash_warning_level: "發鈔錢箱警告水位",
        cash_stop_level: "發鈔錢箱即停水位",
        cash_overflow_warning_level: "鈔票錢箱警告水位",
        cash_overflow_stop_level: "鈔票錢箱停止水位",
        coin_warning_water_level: "硬幣警告水位",
        coin_stop_water_level: "硬幣停止水位",
        coin_overflow_warning_level: "溢幣區(硬幣)警告水位",
        coin_overflow_stop_level: "溢幣區(硬幣)停止水位",
      },
      message: {
        update_error: "更新失敗",
        update_error_level: "設定異常",
        no_select_store: "未選擇門市",
        update: "更新成功",
      },
    },
    cashier_manage: {
      cashier_manage: "機器管理",
      search: {
        start_date: "開始時間",
        end_date: "結束時間",
        store: "門市",
      },
      columns: {
        cashier_id: "機器編號",
        cashier_name: "機器名稱",
        store: "門市",
        store_otp: "OTP",
        update_time: "更新時間",
        update_admin: "更新人員",
      },
      cashier_info_block: {
        add_title: "新增機台",
        edit_title: "設定機台",
        cashier_name: "機台名稱",
      },
      message: {
        false: "失敗",
        create_error: "新增失敗",
        create: "新增成功",
        update_error: "更新失敗",
        update: "更新成功",
        no_cashier_name: "未輸入門市名稱",
      },
    },
    cashier_alarm_list: {
      cashier_alarm_list: "機器警報",
      search: {
        start_date: "開始時間",
        end_date: "結束時間",
        location: "案場",
        alarm_priority: "警報等級",
        equipment: "設備名稱",
        not_returning: "沒有復歸",
        store: "門市",
      },
      columns: {
        no: "編號",
        location: "案場",
        equipment: "設備",
        alarm_time: "警報時間",
        recovery_time: "復歸時間",
        comfirm_time: "確認時間",
        message: "訊息",
        alarm_priority: "警報等級",
        value: "值",
        store: "門市",
        alarm_time: "時間",
        alarm_type: "類型",
        alarm_code: "Code",
        alarm_message: "Message",
      },
    },

    admin_users: {
      title: "使用者管理",
      RI: "必填項目",
      add: "新增",
      edit: "編輯",
      columns: {
        user_id: "帳號",
        name: "姓名",
        user_role: "所屬角色",
        calories: "類別",
        email: "電子郵件",
        cellphone: "手機號碼",
        telephone: "電話號碼",
        password: "密碼",
        password1: "再次輸入密碼",
        password2: "新密碼",
        password3: "再次輸入新密碼",
        role: "角色",
        station: "可查看案場",
      },
      message: {
        id: "沒有輸入帳號",
        password: "沒有輸入密碼",
        checkPassword: "沒有輸入確認密碼",
        password_dc: "密碼與確認密碼不一致，請重新輸入",
        name: "沒有輸入名字",
        telephone: "沒有輸入電話號碼",
        cellphone: "沒有輸入手機號碼",
        email: "沒有輸入電子郵件",
        norole: "沒有選擇角色",
        delete_error: "刪除失敗",
        update_error: "更新失敗",
        success_error: "建立失敗",
        delete: "刪除成功",
        update: "更新成功",
        success: "建立成功",
        alart: "提醒",
        delete_user: "刪除使用者嗎？",
      },
    },
    admin_page_permission_setting: {
      columns: {
        role_name: "角色名稱",
        view_page: "頁面權限設定",
        view_store: "門市顯示設定",
      },
    },
  },

  menu: {
    index: "即時總覽",
    admin: "帳號管理",
    admin_users: "使用者管理",
    group_manage: "群組管理",
    admin_page_permission_setting: "角色頁面權限設定",
    cashier: "機器管理",
    cashier_manage: "機器管理",
    cashier_alarm_list: "機器警報",
    store_manage: "門市管理",
    store_setting: "門市設定",
    store_list: "門市列表",
    store_allowance_setting: "門市零用金設定",
    store_cash_warn_setting: "門市現金警戒設定",
    store_received_ledger_list: "收款報表",
    store_received_statement_list: "收款明細",
    store_business_list: "營業報表",
    store_transaction_statement_list: "物流交易明細",
    store_transaction_info_list: "物流交易資料",
    store_transaction_fail_list: "異常交易紀錄",
    store_daily_cash_list: "每日現金資料",
    store_machine_alarm_list: "門市機器異常報表",
    store_currency_details: "門市貨幣異動明細",
  },
  taiwan_place: {
    keelung_city: "基隆市",
    new_taipei_city: "新北市",
    taipei_city: "臺北市",
    taoyuan_city: "桃園市",
    hsinchu_county: "新竹縣",
    hsinchu_city: "新竹市",
    miaoli_city: "苗栗市",
    miaoli_county: "苗栗縣",
    taichung_city: "臺中市",
    changhua_county: "彰化縣",
    changhua_city: "彰化市",
    nantou_city: "南投市",
    nantou_county: "南投縣",
    yunlin_county: "雲林縣",
    chiayi_county: "嘉義縣",
    chiayi_city: "嘉義市",
    tainan_city: "臺南市",
    kaohsiung_city: "高雄市",
    pingtung_county: "屏東縣",
    pingtung_city: "屏東市",
    yilan_county: "宜蘭縣",
    yilan_city: "宜蘭市",
    hualien_county: "花蓮縣",
    hualien_city: "花蓮市",
    taitung_city: "臺東市",
    taitung_county: "臺東縣",
    penghu_county: "澎湖縣",
    green_island: "綠島",
    orchid_island: "蘭嶼",
    kinmen_county: "金門縣",
    matsu: "馬祖",
    lienchiang_county: "連江縣",
  },
  api_msg: {
    // 後端的 message 訊息
    menu: {
      test: "測試選單",
    },
  },
};
