<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{
	/**
	 * Leo
	 * 取得門市機器異常報表
	 * @param start_date, end_date, store
	 * @return list[]
	 */
	public function SelectStoreAlarmList($params)
	{


		$a_where_arr = []; //sql條件陣列 
		$a_where_arr_val = [];
		$s_where_arr = ""; //sql條件字串，用$a_where_arr條件陣列轉換而來

		// 時間條件
		$a_where_arr[] = "_sar.create_at BETWEEN :startTime AND :endTime";
		$a_where_arr[] = "_sar.alarm_code <> 0"; //過濾警報碼為正常的資料
		$a_where_arr_val["startTime"] = date('Y-m-d 00:00:00', strtotime($params['start_date']));
		$a_where_arr_val["endTime"] = date('Y-m-d 23:59:59', strtotime($params['end_date']));

		// 門市判斷條件
		if ($params['store'] != 0) {
			$a_where_arr[] = "_s.store_id = :store";
			$a_where_arr_val["store"] = $params['store'];
		}

		//門市查詢控制項 store_ctrl 0:只顯示營運中門市 1:顯示全門市
		if ($this->store_ctrl == 0) {
			$a_where_arr[] = " _s.store_state = 1 ";
		}

		//sql條件陣列轉換
		if (!empty($a_where_arr)) {
			$s_where_arr = " WHERE " . implode(" AND ", $a_where_arr);
		}
		//拼接sql字串
		$sql = sprintf(
			"SELECT 
				_sar.alarm_code,
				_sar.alarm_name,
				_sar.alarm_note,
				_sar.create_at AS create_time,				
				_s.store_id,
				_s.store_name,
				_c.cashier_name
			FROM 
				[%s].[dbo].[store_alarm_report] AS _sar
				LEFT JOIN [%s].[dbo].[store] AS _s ON _s.store_id = _sar.store_id
				LEFT JOIN [%s].[dbo].[cashier] AS _c ON _c.cashier_id = _sar.cashier_id
			%s
			",
			$this->database_alarm,
			$this->database_trend,
			$this->database_trend,
			$s_where_arr
		);
		//準備執行sql
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute($a_where_arr_val);
		$a_store_data = $sth->fetchAll(PDO::FETCH_ASSOC);
		return $a_store_data;
	}
}
