<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{
	/**
	 * Leo
	 * 取得門市零用金列表
	 * @param start_date, end_date, store
	 * @return list[]
	 */
	public function SelectStoreAllowanceList($params)
	{


		$a_where_arr = []; //sql條件陣列 
		$a_where_arr_val = [];
		$s_where_arr = ""; //sql條件字串，用$a_where_arr條件陣列轉換而來

		// 門市判斷條件
		if ($params['store'] != 0) {
			$a_where_arr[] = "_s.store_id = :store";
			$a_where_arr_val["store"] = $params['store'];
		}

		//門市查詢控制項 store_ctrl 0:只顯示營運中門市 1:顯示全門市
		if ($this->store_ctrl == 0) {
			$a_where_arr[] = " _s.store_state = 1 ";
		}

		//sql條件陣列轉換
		if (!empty($a_where_arr)) {
			$s_where_arr = " WHERE " . implode(" AND ", $a_where_arr);
		}
		//拼接sql字串
		$sql = sprintf(
			"SELECT 
				_s.store_id,
				_s.store_name,
				_s.petty_cash_500,
				_s.petty_cash_100,
				_s.petty_cash_50,
				_s.petty_cash_10,
				_s.petty_cash_5,
				_s.petty_cash_1
			FROM 
				[%s].[dbo].[store] AS _s
			%s
			",
			$this->database_trend,
			$s_where_arr
		);
		//準備執行sql
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute($a_where_arr_val);
		$a_store_data = $sth->fetchAll(PDO::FETCH_ASSOC);
		foreach ($a_store_data as $k => &$v) {
			$v["total_amount"] = bcmul($v["petty_cash_500"], 500, 0) + bcmul($v["petty_cash_100"], 100, 0) + bcmul($v["petty_cash_50"], 50, 0) + bcmul($v["petty_cash_10"], 10, 0) + bcmul($v["petty_cash_5"], 5, 0) + bcmul($v["petty_cash_1"], 1, 0);
		}

		return $a_store_data;
	}

	/**
	 * Leo
	 * 編輯門市零用金
	 * @param store_id
	 * @return list[]
	 */
	public function SelectEditAllowance($params)
	{
		//拼接sql字串
		$sql = sprintf(
			"SELECT 
				_s.store_id,
				_s.store_name,
				_s.petty_cash_500,
				_s.petty_cash_100,
				_s.petty_cash_50,
				_s.petty_cash_10,
				_s.petty_cash_5,
				_s.petty_cash_1
			FROM 
				[%s].[dbo].[store] AS _s
			WHERE
				_s.store_id = :store_id
			",
			$this->database_trend
		);
		//準備執行sql
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute([
			"store_id" => $params["store_id"]
		]);
		$row = $sth->fetchAll(PDO::FETCH_ASSOC);
		foreach ($row as $k => &$v) {
			$v["total_amount"] = bcmul($v["petty_cash_500"], 500, 0) + bcmul($v["petty_cash_100"], 100, 0) + bcmul($v["petty_cash_50"], 50, 0) + bcmul($v["petty_cash_10"], 10, 0) + bcmul($v["petty_cash_5"], 5, 0) + bcmul($v["petty_cash_1"], 1, 0);
			$a_store_data = $v;
		}
		return $a_store_data;
	}

	/**
	 * Leo
	 * 更新門市零用金
	 */
	public function ChangeUpdateAllowance($params)
	{
		//門市id可能為多個 方便一次更新多門市 格式如下 111,123,151 已,區分
		$s_store_id_list = (string) $params["store_id"];
		$n_petty_cash_500 = (int) $params["petty_cash_500"];
		$n_petty_cash_100 = (int) $params["petty_cash_100"];
		$n_petty_cash_50 = (int) $params["petty_cash_50"];
		$n_petty_cash_10 = (int) $params["petty_cash_10"];
		$n_petty_cash_5 = (int) $params["petty_cash_5"];
		$n_petty_cash_1 = (int) $params["petty_cash_1"];

		if ($s_store_id_list == "") {
			throw new Exception("store 參數錯誤");
		}
		if ($n_petty_cash_500 > 100 || $n_petty_cash_500 < 0) {
			throw new Exception("petty_cash_500 參數錯誤");
		}
		if ($n_petty_cash_100 > 1000 || $n_petty_cash_100 < 0) {
			throw new Exception("petty_cash_100 參數錯誤");
		}
		if ($n_petty_cash_50 > 700 || $n_petty_cash_50 < 0) {
			throw new Exception("petty_cash_50 參數錯誤");
		}
		if ($n_petty_cash_10 > 900 || $n_petty_cash_10 < 0) {
			throw new Exception("petty_cash_10 參數錯誤");
		}
		if ($n_petty_cash_5 > 1200 || $n_petty_cash_5 < 0) {
			throw new Exception("petty_cash_5 參數錯誤");
		}
		if ($n_petty_cash_1 > 1500 || $n_petty_cash_1 < 0) {
			throw new Exception("petty_cash_1 參數錯誤");
		}

		//拼接sql字串
		try {
			$sql = sprintf(
				"UPDATE [%s].[dbo].[store] 
				SET 
				[petty_cash_500] = :petty_cash_500,
				[petty_cash_100] = :petty_cash_100,
				[petty_cash_50] = :petty_cash_50,
				[petty_cash_10] = :petty_cash_10,
				[petty_cash_5] = :petty_cash_5,
				[petty_cash_1] = :petty_cash_1
				WHERE
					[store_id] IN (%s);
				",
				$this->database_trend,
				$s_store_id_list
			);
			//準備執行sql
			$sth = $this->pdo_sql->prepare($sql);
			$sth->execute([
				"petty_cash_500" => $n_petty_cash_500,
				"petty_cash_100" => $n_petty_cash_100,
				"petty_cash_50" => $n_petty_cash_50,
				"petty_cash_10" => $n_petty_cash_10,
				"petty_cash_5" => $n_petty_cash_5,
				"petty_cash_1" => $n_petty_cash_1,
			]);
			if ($sth->rowCount() == 0) {
				throw new Exception("store資料表更新失敗");
			}
			return true;
		} catch (Exception $mes) {
			$this->pdo_sql->rollBack();
			return $mes->getMessage();
		}
	}
}
