var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
  },
  data() {
    return {
      VarMenuPage: "store_allowance_setting",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],
      isModalOpen: false,
      store: [],
      search: {
        store: "1",
      },
      select_store: [],
      edit_allowance_info: {
        show: false, // 編輯零用金版面顯示
        show_store_info: false, // 顯示門市編號及門市名稱 ((多選設定下圍false 僅單一門市設定時為true
        show_edit_btn: false, // 編輯零用金按鈕
        show_delete_btn: false, // 刪除零用金按鈕

        editUserDisable: false, // 編輯那些資料不能更新設定
        store_id: null, //門市編號
        store_name: null, //門市編號
        petty_cash_500: 0, // 面額_500
        petty_cash_100: 0, // 面額_100
        petty_cash_50: 0, // 面額_50
        petty_cash_10: 0, // 面額_10
        petty_cash_5: 0, // 面額_5
        petty_cash_1: 0, // 面額_1
        total_amount: 0, //總額
        cash_500_max: 100, // 面額_500_數量上限
        cash_100_max: 1000, // 面額_100_數量上限
        cash_50_max: 700, // 面額_50_數量上限
        cash_10_max: 900, // 面額_10_數量上限
        cash_5_max: 1200, // 面額_5_數量上限
        cash_1_max: 1500, // 面額_1_數量上限

        enabled: false,
      },
    };
  },
  watch: {
    "edit_allowance_info.petty_cash_500": {
      handler(nv, ov) {
        if (parseInt(nv) > this.edit_allowance_info.cash_500_max) {
          this.edit_allowance_info.petty_cash_500 =
            this.edit_allowance_info.cash_500_max;
        } else if (parseInt(nv) < 0) {
          this.edit_allowance_info.petty_cash_500 = 0;
        }
      },
    },
    "edit_allowance_info.petty_cash_100": {
      handler(nv, ov) {
        if (parseInt(nv) > this.edit_allowance_info.cash_100_max) {
          this.edit_allowance_info.petty_cash_100 =
            this.edit_allowance_info.cash_100_max;
        } else if (parseInt(nv) < 0) {
          this.edit_allowance_info.petty_cash_100 = 0;
        }
      },
    },
    "edit_allowance_info.petty_cash_50": {
      handler(nv, ov) {
        if (parseInt(nv) > this.edit_allowance_info.cash_50_max) {
          this.edit_allowance_info.petty_cash_50 =
            this.edit_allowance_info.cash_50_max;
        } else if (parseInt(nv) < 0) {
          this.edit_allowance_info.petty_cash_50 = 0;
        }
      },
    },
    "edit_allowance_info.petty_cash_10": {
      handler(nv, ov) {
        if (parseInt(nv) > this.edit_allowance_info.cash_10_max) {
          this.edit_allowance_info.petty_cash_10 =
            this.edit_allowance_info.cash_10_max;
        } else if (parseInt(nv) < 0) {
          this.edit_allowance_info.petty_cash_10 = 0;
        }
      },
    },
    "edit_allowance_info.petty_cash_5": {
      handler(nv, ov) {
        if (parseInt(nv) > this.edit_allowance_info.cash_5_max) {
          this.edit_allowance_info.petty_cash_5 =
            this.edit_allowance_info.cash_5_max;
        } else if (parseInt(nv) < 0) {
          this.edit_allowance_info.petty_cash_5 = 0;
        }
      },
    },
    "edit_allowance_info.petty_cash_1": {
      handler(nv, ov) {
        if (parseInt(nv) > this.edit_allowance_info.cash_1_max) {
          this.edit_allowance_info.petty_cash_1 =
            this.edit_allowance_info.cash_1_max;
        } else if (parseInt(nv) < 0) {
          this.edit_allowance_info.petty_cash_1 = 0;
        }
      },
    },
  },
  computed: {
    // 為了配合多國語系, columns 需使用 computed
    columns() {
      return [
        {
          name: "store_id",
          required: true,
          label: this.$t("page.store_allowance_setting.columns.store_id"),
          align: "left",
          field: "store_id",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_name",
          required: true,
          label: this.$t("page.store_allowance_setting.columns.store_name"),
          align: "left",
          field: "store_name",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "total_amount",
          required: true,
          label: this.$t("page.store_allowance_setting.columns.total_amount"),
          align: "left",
          field: "total_amount",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "petty_cash_100",
          required: true,
          label: this.$t("page.store_allowance_setting.columns.petty_cash_100"),
          align: "left",
          field: "petty_cash_100",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "petty_cash_50",
          required: true,
          label: this.$t("page.store_allowance_setting.columns.petty_cash_50"),
          align: "left",
          field: "petty_cash_50",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "petty_cash_10",
          required: true,
          label: this.$t("page.store_allowance_setting.columns.petty_cash_10"),
          align: "left",
          field: "petty_cash_10",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "petty_cash_5",
          required: true,
          label: this.$t("page.store_allowance_setting.columns.petty_cash_5"),
          align: "left",
          field: "petty_cash_5",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "petty_cash_1",
          required: true,
          label: this.$t("page.store_allowance_setting.columns.petty_cash_1"),
          align: "left",
          field: "petty_cash_1",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
      ];
    },
    // 表單金額加總顯示
    total_amount() {
      this.edit_allowance_info.total_amount =
        Number(this.edit_allowance_info.petty_cash_500) * 500 +
        Number(this.edit_allowance_info.petty_cash_100) * 100 +
        Number(this.edit_allowance_info.petty_cash_50) * 50 +
        Number(this.edit_allowance_info.petty_cash_10) * 10 +
        Number(this.edit_allowance_info.petty_cash_5) * 5 +
        Number(this.edit_allowance_info.petty_cash_1);
      return this.edit_allowance_info.total_amount;
    },
    // 異常訊息
    message_alart() {
      return [
        {
          label: "更新成功",
          value: this.$t("page.store_allowance_setting.message.update"),
        },
        {
          label: "更新失敗",
          value: this.$t("page.store_allowance_setting.message.update_error"),
        },
        {
          label: "更新失敗",
          value: this.$t(
            "page.store_allowance_setting.message.update_error_count"
          ),
        },
      ];
    },
    //查詢功能開啟與否判斷
    search_cheak() {
      return this.$root.FnChkPageFunction("search");
    },
    //匯出功能開啟與否判斷
    export_cheak() {
      return this.$root.FnChkPageFunction("export");
    },
  },
  mounted() {
    let that = this;
    that.load_store_option();
  },
  methods: {
    //多選設定
    open_allowance_info_multiple() {
      let that = this;
      //清除暫存資料
      this.$data.edit_allowance_info = this.$options.data().edit_allowance_info;
      if (this.select_store.length == 0) {
        that.FnNotify(
          `${that.$t("page.store_allowance_setting.message.no_select_store")}`,
          "error"
        );
      } else {
        that.edit_allowance_info["show"] = true;
        that.edit_allowance_info["show_edit_btn"] = true;
        var store_id_list = [];
        this.select_store.forEach((el) => {
          store_id_list.push(el.store_id);
        });
        that.edit_allowance_info["store_id"] = store_id_list.toString();
      }
    },
    // 載入門市下拉選單
    load_store_option() {
      let that = this;
      var params = {
        Action: "StoreOption",
        Datas: {},
        menu_page: "sys_component",
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          _.each(res.data.data, (item) => {
            that.store.push({ label: item.store_name, value: item.store_id });
          });
          that.search.store = _.first(that.store)["value"];
          that.searsh_list();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    searsh_list() {
      let that = this;
      that.$q.loading.show();
      var params = {
        Action: "StoreAllowanceList",
        Datas: that.search,
      };
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          that.$set(that, "tableData", res.data.data);
          that.$q.loading.hide();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },

    //	關閉設定畫面
    cancel_store_allowance() {
      this.edit_allowance_info["show"] = false;
    },
    //	開啟設定畫面
    edit_store_allowance(rowData) {
      let that = this;
      that.edit_allowance_info["show_edit_btn"] = true;

      var param = {
        Action: "EditAllowance",
        Datas: {
          store_id: rowData.store_id,
        },
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(param)
        .then(function (res) {
          that.edit_allowance_info["petty_cash_500"] =
            res.data.data.petty_cash_500;
          that.edit_allowance_info["petty_cash_100"] =
            res.data.data.petty_cash_100;
          that.edit_allowance_info["petty_cash_50"] =
            res.data.data.petty_cash_50;
          that.edit_allowance_info["petty_cash_10"] =
            res.data.data.petty_cash_10;
          that.edit_allowance_info["petty_cash_5"] = res.data.data.petty_cash_5;
          that.edit_allowance_info["petty_cash_1"] = res.data.data.petty_cash_1;
          that.edit_allowance_info["total_amount"] = res.data.data.total_amount;
          that.edit_allowance_info["store_id"] = rowData.store_id;
          that.edit_allowance_info["store_name"] = rowData.store_name;
          that.edit_allowance_info["show_store_info"] = true;
          that.edit_allowance_info["show"] = true;

          that.$q.loading.hide();
        })
        .catch(async function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },

    //	更新
    save_store_allowance() {
      let that = this;
      that.$q.loading.show();
      let error_msg = "";
      //	各面額數量確認
      if (
        that.edit_allowance_info.petty_cash_500 >
          that.edit_allowance_info.cash_500_max ||
        that.edit_allowance_info.petty_cash_500 < 0
      ) {
        error_msg = `${that.$t(
          "page.store_allowance_setting.columns.petty_cash_500"
        )} ${that.message_alart[2]["value"]}`;
      }

      if (
        that.edit_allowance_info.petty_cash_100 >
          that.edit_allowance_info.cash_100_max ||
        that.edit_allowance_info.petty_cash_100 < 0
      ) {
        error_msg = `${that.$t(
          "page.store_allowance_setting.columns.petty_cash_100"
        )} ${that.message_alart[2]["value"]}`;
      }

      if (
        that.edit_allowance_info.petty_cash_50 >
          that.edit_allowance_info.cash_50_max ||
        that.edit_allowance_info.petty_cash_50 < 0
      ) {
        error_msg = `${that.$t(
          "page.store_allowance_setting.columns.petty_cash_50"
        )} ${that.message_alart[2]["value"]}`;
      }

      if (
        that.edit_allowance_info.petty_cash_10 >
          that.edit_allowance_info.cash_10_maxs ||
        that.edit_allowance_info.petty_cash_10 < 0
      ) {
        error_msg = `${that.$t(
          "page.store_allowance_setting.columns.petty_cash_10"
        )} ${that.message_alart[2]["value"]}`;
      }

      if (
        that.edit_allowance_info.petty_cash_5 >
          that.edit_allowance_info.cash_5_max ||
        that.edit_allowance_info.petty_cash_5 < 0
      ) {
        error_msg = `${that.$t(
          "page.store_allowance_setting.columns.petty_cash_5"
        )} ${that.message_alart[2]["value"]}`;
      }
      if (
        that.edit_allowance_info.petty_cash_1 >
          that.edit_allowance_info.cash_1_max ||
        that.edit_allowance_info.petty_cash_1 < 0
      ) {
        error_msg = `${that.$t(
          "page.store_allowance_setting.columns.petty_cash_1"
        )} ${that.message_alart[2]["value"]}`;
      }
      if (error_msg != "") {
        that.FnNotify(error_msg, "error");
        this.$q.loading.hide();
        return;
      }
      var param = {
        Action: "UpdateAllowance",
        Datas: {
          store_id: that.edit_allowance_info.store_id,
          petty_cash_500: that.edit_allowance_info.petty_cash_500,
          petty_cash_100: that.edit_allowance_info.petty_cash_100,
          petty_cash_50: that.edit_allowance_info.petty_cash_50,
          petty_cash_10: that.edit_allowance_info.petty_cash_10,
          petty_cash_5: that.edit_allowance_info.petty_cash_5,
          petty_cash_1: that.edit_allowance_info.petty_cash_1,
        },
      };
      that
        .FnWebAPIPost(param)
        .then(function (res) {
          let result = res.data.result;
          if (result) {
            that.FnNotify(that.message_alart[0]["value"], "success");
            that.searsh_list();
            that.edit_allowance_info["show"] = false;
          } else {
            that.FnNotify(that.message_alart[1]["value"], "error");
            that.searsh_list();
            that.edit_allowance_info["show"] = true;
          }
        })
        .catch(function (err) {
          this.$q.loading.hide();
          console.log(err);
        });
    },
  },
};
