<?php
/* 各API 需有 token_verify() token驗證function ，因各API撈取API金鑰方式不同*/
class WebAPIForMenuPage extends base_class
{


    /**
     * Leo
     * 取得門市剩餘金額
     */
    public function Select_store_remain_money($params)
    {
        //設定查詢資料
        $n_store_id = (int) $params["store"];




        //拼接sql字串
        $sql = sprintf(
            "SELECT
                _s.store_id,
                _s.store_open_at,
                _s.store_area,
                v_sls.statistics_at,
                v_sls.last_cycle_box_500,
                v_sls.last_cycle_box_100,
                v_sls.last_cycle_box_50,
                v_sls.last_cycle_box_10,
                v_sls.last_cycle_box_5,
                v_sls.last_cycle_box_1,
                v_sls.last_safe_box_1000,
                v_sls.last_safe_box_500,
                v_sls.last_safe_box_100,
                v_sls.last_safe_box_50,
                v_sls.last_safe_box_10,
                v_sls.last_safe_box_5,
                v_sls.last_safe_box_1,
                v_sls.sub_total_1000_in,
                v_sls.sub_total_500_in,
                v_sls.sub_total_100_in,
                v_sls.sub_total_500_out,
                v_sls.sub_total_100_out,
                v_sts.cash_1000_in,
                v_sts.cash_500_in,
                v_sts.cash_100_in,
                v_sts.cash_50_in,
                v_sts.cash_10_in,
                v_sts.cash_5_in,
                v_sts.cash_1_in,
                v_sts.cash_500_out,
                v_sts.cash_100_out,
                v_sts.cash_50_out,
                v_sts.cash_10_out,
                v_sts.cash_5_out,
                v_sts.cash_1_out,
                v_sts.safe_box_1000,
                v_sts.safe_box_500,
                v_sts.safe_box_100,
                v_sts.safe_box_50,
                v_sts.safe_box_10,
                v_sts.safe_box_5,
                v_sts.safe_box_1,
                v_sts.cycle_box_500,
                v_sts.cycle_box_100,
                v_sts.cycle_box_50,
                v_sts.cycle_box_10,
                v_sts.cycle_box_5,
                v_sts.cycle_box_1,
                v_sts.sub_box_1000_in,
                v_sts.sub_box_500_in,
                v_sts.sub_box_100_in,
                v_sts.sub_box_500_out,
                v_sts.sub_box_100_out
            FROM 
                [%s].[dbo].[store] AS _s		
                LEFT JOIN [%s].[dbo].[v_store_yesterday_currency_statement] AS v_sls ON v_sls.store_id = _s.store_id
                LEFT JOIN [%s].[dbo].[v_store_today_statistics_data] AS v_sts ON v_sts.store_id = _s.store_id
            WHERE
                _s.store_id = :store_id
            ",
            $this->database_trend,
            $this->database_trend,
            $this->database_trend
        );
        //準備執行sql
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute(["store_id" => $n_store_id]);
        $row = $sth->fetch(PDO::FETCH_ASSOC);
        //整理回傳資料
        $res = [];

        //循環箱各面額數量計算 最後一次日結 + (當日循環箱入鈔 - 當日循環箱出鈔) + 當日循環箱換補操作
        $n_cycle_500 = $row["last_cycle_box_500"] + ($row["cash_500_in"] - $row["cash_500_out"]) + $row["cycle_box_500"];
        $n_cycle_100 = $row["last_cycle_box_100"] + ($row["cash_100_in"] - $row["cash_100_out"]) + $row["cycle_box_100"];
        $n_cycle_50 = $row["last_cycle_box_50"] + ($row["cash_50_in"] - $row["cash_50_out"]) + $row["cycle_box_50"];
        $n_cycle_10 = $row["last_cycle_box_10"] + ($row["cash_10_in"] - $row["cash_10_out"]) + $row["cycle_box_10"];
        $n_cycle_5 = $row["last_cycle_box_5"] + ($row["cash_5_in"] - $row["cash_5_out"]) + $row["cycle_box_5"];
        $n_cycle_1 = $row["last_cycle_box_1"] + ($row["cash_1_in"] - $row["cash_1_out"]) + $row["cycle_box_1"];
        //鈔票保全箱
        $n_safe_box_1000 = $row["last_safe_box_1000"] + $row["safe_box_1000"] + $row["cash_1000_in"];
        $n_safe_box_500 = $row["last_safe_box_500"] + $row["safe_box_500"];
        $n_safe_box_100 = $row["last_safe_box_100"] + $row["safe_box_100"];
        //硬幣溢幣區
        $n_safe_box_50 = $row["last_safe_box_50"] + $row["safe_box_50"];
        $n_safe_box_10 = $row["last_safe_box_10"] + $row["safe_box_10"];
        $n_safe_box_5 = $row["last_safe_box_5"] + $row["safe_box_5"];
        $n_safe_box_1 = $row["last_safe_box_1"] + $row["safe_box_1"];
        //出鈔機
        $n_sub_out_box_500 = $row["sub_box_500_out"] + $row["sub_total_500_out"];
        $n_sub_out_box_100 = $row["sub_box_100_out"] + $row["sub_total_100_out"];
        //入鈔機
        $n_sub_in_box_1000 = $row["sub_total_1000_in"] + $row["sub_box_1000_in"];
        $n_sub_in_box_500 = $row["sub_total_500_in"] + $row["sub_box_500_in"];
        $n_sub_in_box_100 = $row["sub_total_100_in"] + $row["sub_box_100_in"];
        $res = [
            "safe_box_1000" => (int) $n_safe_box_1000,
            "safe_box_500" => (int) $n_safe_box_500,
            "safe_box_100" => (int) $n_safe_box_100,
            "safe_box_50" => (int) $n_safe_box_50,
            "safe_box_10" => (int) $n_safe_box_10,
            "safe_box_5" => (int) $n_safe_box_5,
            "safe_box_1" => (int) $n_safe_box_1,
            "cycle_500" => (int) $n_cycle_500,
            "cycle_100" => (int) $n_cycle_100,
            "cycle_50" => (int) $n_cycle_50,
            "cycle_10" => (int) $n_cycle_10,
            "cycle_5" => (int) $n_cycle_5,
            "cycle_1" => (int) $n_cycle_1,
            "sub_out_500" => (int) $n_sub_out_box_500,
            "sub_out_100" => (int) $n_sub_out_box_100,
            "sub_in_1000" => (int) $n_sub_in_box_1000,
            "sub_in_500" => (int) $n_sub_in_box_500,
            "sub_in_100" => (int) $n_sub_in_box_100,
        ];


        return $res;
    }
    /**
     * Leo
     * api 驗證
     */
    public function api_verify($token, $params)
    {
        //門市編號
        $n_store_id = (int) $params["store"];
        if ($n_store_id == 0) { //門市編號為空
            throw new Exception("store 欄位不可為空", 91000);
        } else {    //檢查門市是否存在
            $sql = sprintf(
                "SELECT 
                        _s.store_id
                FROM 	
                    [%s].[dbo].[store] AS _s 
                WHERE
                    _s.store_id = :store_id ",
                $this->database_trend
            );
            //準備執行sql
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "store_id" => $n_store_id
            ]);
            $row = $sth->fetch(PDO::FETCH_ASSOC);
            if (empty($row)) {
                throw new Exception("store 異常", 91000);
            }
        }
        //機台序號
        $s_cashier_id = (string) $params["cashier"];
        if ($s_cashier_id == "") { //機台編號為空
            throw new Exception("cashier 欄位不可為空", 91000);
        } else { //檢查機台是否存在
            $sql = sprintf(
                "SELECT 
                        _c.cashier_id
                FROM 	
                    [%s].[dbo].[cashier] AS _c
                WHERE
                    _c.cashier_id = :cashier_id ",
                $this->database_trend
            );
            //準備執行sql
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "cashier_id" => $s_cashier_id
            ]);
            $row = $sth->fetch(PDO::FETCH_ASSOC);
            if (empty($row)) {
                throw new Exception("cashier error", 91000);
            }
        }
        //時間戳(單位秒)
        $s_send_at = (string) $params["send_at"];
        if ($s_send_at == "") { //時間戳為空
            throw new Exception("send_at 欄位不可為空", 91000);
        } else if ($this->check_timestamp_format($s_send_at) != true) {
            throw new Exception("send_at format error", 91000);
        }
        //Token
        if (trim($token) == "") { //Token為空
            throw new Exception("token 欄位不可為空", 91000);
        }
        //依據資料查詢門市API金鑰來進行Token驗證
        $sql = sprintf(
            "SELECT 
                    _s.store_api_key,
                    _c.cashier_id
            FROM 	
                 [%s].[dbo].[cashier] AS _c
                 LEFT JOIN [%s].[dbo].[store] AS _s ON _s.store_id = _c.store_id
            WHERE
                _c.store_id = :store_id AND
                _c.cashier_id = :cashier_id",
            $this->database_trend,
            $this->database_trend
        );
        //準備執行sql
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "store_id" => $n_store_id,
            "cashier_id" => $s_cashier_id
        ]);
        $row = $sth->fetch(PDO::FETCH_ASSOC);
        if (!empty($row)) {
            $s_api_key = $row["store_api_key"];
            if ($this->shopee_api_token_verify($token, $s_api_key, $s_send_at) != true) {
                throw new Exception("Token Verification Failed", 91001);
            }
        } else {
            //查詢不到該門市該機台
            throw new Exception("store and cashier not binding", 91000);
        }

        //更新最後連線時間
        $this->cashier_connect_time_update($n_store_id, $s_cashier_id, $s_send_at);
    }
}
