<?php
// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{
	/**
	 * Leo
	 * 取得機器警報列表
	 * @param start_date, end_date, store
	 * @return list[]
	 */
	public function SelectAlarmList($params)
	{


		$a_where_arr = []; //sql條件陣列 
		$a_where_arr_val = [];
		$s_where_arr = ""; //sql條件字串，用$a_where_arr條件陣列轉換而來

		// 時間條件
		$a_where_arr[] = "_car.create_at BETWEEN :startTime AND :endTime";
		$a_where_arr_val["startTime"] = date('Y-m-d 00:00:00', strtotime($params['start_date']));
		$a_where_arr_val["endTime"] = date('Y-m-d 23:59:59', strtotime($params['end_date']));

		// 門市判斷條件
		if ($params['store'] != 0) {
			$a_where_arr[] = "_car.store_id = :store";
			$a_where_arr_val["store"] = $params['store'];
		}

		//門市查詢控制項 store_ctrl 0:只顯示營運中門市 1:顯示全門市
		if ($this->store_ctrl == 0) {
			$a_where_arr[] = " _s.store_state = 1 ";
		}
		//sql條件陣列轉換
		if (!empty($a_where_arr)) {
			$s_where_arr = " WHERE " . implode(" AND ", $a_where_arr);
		}
		//拼接sql字串
		$sql = sprintf(
			"SELECT 
				_car.create_at AS alarm_time,
				_car.alarm_type,
				_car.alarm_code,
				_car.alarm_message,
				_s.store_name
			FROM 
				[%s].[dbo].[cashier_alarm_report] AS _car
				LEFT JOIN [%s].[dbo].[store] AS _s ON _s.store_id = _car.store_id
			%s
			",
			$this->database_alarm,
			$this->database_trend,
			$s_where_arr
		);
		//準備執行sql
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute($a_where_arr_val);
		return $sth->fetchAll(PDO::FETCH_ASSOC);
	}
}
