var page_function = {
  components: {
    "data-table": httpVueLoader("components/layout/data_table.vue"),
  },
  data() {
    return {
      VarMenuPage: "store_list",
      VarMenu: "shopee",
      VarPageContainerCss: "padding:10px;",
      tableData: [],
      isModalOpen: false,
      store: [],
      store_area: [
        { label: "北部", value: 1 },
        { label: "中部", value: 2 },
        { label: "南部", value: 3 },
      ],
      store_state: [
        { label: "尚未營運", value: 0 },
        { label: "營運中", value: 1 },
      ],
      search: {
        store: "1",
      },
      store_info: {
        show: false, // 新增/編輯門市版面顯示
        show_add_btn: false, // 新增門市按鈕
        show_edit_btn: false, // 編輯門市按鈕
        show_delete_btn: false, // 刪除門市按鈕

        edit_user_disable: false, // 編輯那些資料不能更新設定
        store_id: null, // 門市ID
        store_name: null, // 門市名稱
        store_open_at: null, // 門市開業日期
        store_area: null, // 門市所屬區域 1.北部 2.中部 3.南部
        store_state: 0, //門市狀態 0:尚未營運 1:營運中
      },
      reset_allowance_info: {
        show: false, // 編輯零用金版面顯示
        show_store_info: false, // 顯示門市編號及門市名稱 ((多選設定下圍false 僅單一門市設定時為true
        show_edit_btn: false, // 編輯零用金按鈕
        show_delete_btn: false, // 刪除零用金按鈕

        editUserDisable: false, // 編輯那些資料不能更新設定
        store_id: null, //門市編號
        store_name: null, //門市編號
        petty_cash_500: 0, // 面額_500
        petty_cash_100: 0, // 面額_100
        petty_cash_50: 0, // 面額_50
        petty_cash_10: 0, // 面額_10
        petty_cash_5: 0, // 面額_5
        petty_cash_1: 0, // 面額_1
        total_amount: 0, //總額
        cash_500_max: 100, // 面額_500_數量上限
        cash_100_max: 1000, // 面額_100_數量上限
        cash_50_max: 700, // 面額_50_數量上限
        cash_10_max: 900, // 面額_10_數量上限
        cash_5_max: 1200, // 面額_5_數量上限
        cash_1_max: 1500, // 面額_1_數量上限

        enabled: false,
      },
    };
  },
  computed: {
    // 為了配合多國語系, columns 需使用 computed
    columns() {
      return [
        {
          name: "store_id",
          required: true,
          label: this.$t("page.store_list.columns.store_id"),
          align: "left",
          field: "store_id",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_name",
          required: true,
          label: this.$t("page.store_list.columns.store_name"),
          align: "left",
          field: "store_name",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_open_at",
          required: true,
          label: this.$t("page.store_list.columns.store_open_at"),
          align: "left",
          field: "store_open_at",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "binding_cashier",
          required: true,
          label: this.$t("page.store_list.columns.binding_cashier"),
          align: "left",
          field: "binding_cashier",
          sortable: true,
          $$is_num_format: false,
          format: function (data) {
            var dt = vm.$t("page.store_list.table_data.no_binding_cashier");
            if (data != "") {
              dt = data;
            }
            return dt;
          },
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
        {
          name: "store_api_key",
          required: true,
          label: this.$t("page.store_list.columns.store_api_key"),
          align: "left",
          field: "store_api_key",
          sortable: true,
          $$is_num_format: false,
          $$data_style: "font-size: 14px; padding: 6px;",
          style: "font-size: 14px; padding: 6px;",
        },
      ];
    },
    // 異常訊息
    message_alart() {
      return [
        {
          label: "操作失敗",
          value: this.$t("page.store_list.message.false"),
        },
        {
          label: "新增成功",
          value: this.$t("page.store_list.message.create"),
        },
        {
          label: "新增失敗",
          value: this.$t("page.store_list.message.create_error"),
        },
        {
          label: "更新成功",
          value: this.$t("page.store_list.message.update"),
        },
        {
          label: "更新失敗",
          value: this.$t("page.store_list.message.update_error"),
        },
        {
          label: "未輸入門市編號",
          value: this.$t("page.store_list.message.no_store_id"),
        },
        {
          label: "未輸入門市名稱",
          value: this.$t("page.store_list.message.no_store_name"),
        },
        {
          label: "未選擇門市區域",
          value: this.$t("page.store_list.message.no_store_area"),
        },
      ];
    },
    //查詢功能開啟與否判斷
    search_cheak() {
      return this.$root.FnChkPageFunction("search");
    },
    //新增功能開啟與否判斷
    add_cheak() {
      return this.$root.FnChkPageFunction("add");
    },
    //編輯功能開啟與否判斷
    edit_cheak() {
      return this.$root.FnChkPageFunction("edit");
    },
  },
  mounted() {
    let that = this;
    that.load_store_option();
  },
  methods: {
    // 載入門市下拉選單
    load_store_option() {
      let that = this;
      var params = {
        Action: "StoreOption",
        Datas: {},
        menu_page: "sys_component",
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          _.each(res.data.data, (item) => {
            that.store.push({ label: item.store_name, value: item.store_id });
          });
          that.search.store = _.first(that.store)["value"];
          that.searsh_list();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
    searsh_list() {
      let that = this;
      var params = {
        Action: "StoreList",
        Datas: that.search,
      };
      that.$q.loading.show();
      that
        .FnWebAPIGet(params)
        .then(function (res) {
          that.$set(that, "tableData", res.data.data);
          that.$q.loading.hide();
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },

    //	關閉設定畫面
    cancel_store_info() {
      this.store_info["show"] = false;
    },
    //	開啟新增/設定畫面
    async open_store_info(type, rowData = undefined) {
      this.$data.store_info = this.$options.data().store_info;
      this.$q.loading.show();
      if (type == "add") {
        this.store_info["show"] = true;
        this.store_info["show_add_btn"] = true;
        this.$q.loading.hide();
      } else {
        let that = this;
        let param = {
          Action: "EditStoreInfo",
          Datas: {
            store: rowData.store_id,
          },
        };
        await that
          .FnWebAPIGet(param)
          .then(function (res) {
            var user_data = res.data.data;
            if (res.data.result) {
              that.store_info["store_id"] = user_data["store_id"];
              that.store_info["store_name"] = user_data["store_name"];
              that.store_info["store_open_at"] = user_data["store_open_at"];
              that.store_info["store_area"] = parseInt(user_data["store_area"]);
              that.store_info["store_state"] = parseInt(user_data["store_state"]);
              that.store_info["show"] = true;
              that.store_info["show_edit_btn"] = true;
              that.$q.loading.hide();
            } else {
              that.FnNotify(that.message_alart[0]["value"], "error");
              that.searsh_list();
            }
          })
          .catch(async function (err) {
            that.$q.loading.hide();
            console.log(err);
          });
      }
    },
    // 新增
    async add_store() {
      let that = this;
      var store_open_at = "";
      // 門市開業時間格式化
      if (
        that.store_info.store_open_at != null &&
        that.store_info.store_open_at != ""
      ) {
        store_open_at = moment(that.store_info.store_open_at).format(
          "YYYY-MM-DD"
        );
      }
      //	門市編號確認
      if (
        that.store_info["store_id"] == null ||
        that.store_info["store_id"] == ""
      ) {
        that.FnNotify(that.message_alart[5]["value"], "error");
        return;
      }
      //	門市名稱確認
      if (
        that.store_info["store_name"] == null ||
        that.store_info["store_name"] == ""
      ) {
        that.FnNotify(that.message_alart[6]["value"], "error");
        return;
      }
      //	門市區域確認
      if (
        that.store_info["store_area"] == null ||
        [1, 2, 3].indexOf(that.store_info["store_area"]) == -1
      ) {
        that.FnNotify(that.message_alart[7]["value"], "error");
        return;
      }
      var param = {
        Action: "AddStore",
        Datas: {
          store_id: that.store_info.store_id,
          store_name: that.store_info.store_name,
          store_open_at: store_open_at,
          store_area: that.store_info.store_area,
          store_state: that.store_info.store_state,
        },
      };
      that.$q.loading.show();
      await that.FnWebAPIPost(param).then(function (res) {
        let result = res.data.result;
        if (result) {
          that.FnNotify(that.message_alart[1]["value"], "success");
          that.searsh_list();
          that.store_info["show"] = false;
        } else {
          that.FnNotify(`${that.message_alart[2]["value"]} : ${res.data.message}`, "error");
          that.searsh_list();
          that.store_info["show"] = true;
        }
      });
    },
    //	更新
    save_store_info() {
      let that = this;
      //	門市名稱確認
      if (
        that.store_info["store_name"] == null ||
        that.store_info["store_name"] == ""
      ) {
        that.FnNotify(that.message_alart[6]["value"], "error");
        return;
      }
      // 門市開業時間格式化
      let store_open_at = null;
      if (
        that.store_info.store_open_at != null &&
        that.store_info.store_open_at != ""
      ) {
        store_open_at = moment(that.store_info.store_open_at).format(
          "YYYY-MM-DD"
        );
      }
      var param = {
        Action: "UpdateStoreInfo",
        Datas: {
          store: that.store_info.store_id,
          store_name: that.store_info.store_name,
          store_open_at: store_open_at,
          store_area: that.store_info.store_area,
          store_state: that.store_info.store_state,
        },
      };
      that.$q.loading.show();
      that
        .FnWebAPIPost(param)
        .then(function (res) {
          if (res.data.result) {
            that.FnNotify(that.message_alart[3]["value"], "success");
            that.searsh_list();
            that.store_info["show"] = false;
          } else {
            that.FnNotify(that.message_alart[4]["value"], "error");
            that.searsh_list();
            that.store_info["show"] = true;
          }
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },

    // 開發測試用

    //	開啟初始化
    open_store_reset(rowData) {
      this.$data.reset_allowance_info =
        this.$options.data().reset_allowance_info;
      this.reset_allowance_info["show"] = true;
      this.reset_allowance_info["store_id"] = rowData.store_id;
      this.reset_allowance_info["store_name"] = rowData.store_name;
      this.reset_allowance_info["show_edit_btn"] = true;
      this.reset_allowance_info["show_store_info"] = true;
    },
    cancel_store_reset() {
      this.reset_allowance_info["show"] = false;
    },
    //設定初始化
    save_store_reset() {
      let that = this;
      var param = {
        Action: "UpdateStoreReset",
        Datas: {
          store: that.reset_allowance_info.store_id,
          petty_cash_500: this.reset_allowance_info["petty_cash_500"],
          petty_cash_100: this.reset_allowance_info["petty_cash_100"],
          petty_cash_50: this.reset_allowance_info["petty_cash_50"],
          petty_cash_10: this.reset_allowance_info["petty_cash_10"],
          petty_cash_5: this.reset_allowance_info["petty_cash_5"],
          petty_cash_1: this.reset_allowance_info["petty_cash_1"],
        },
      };
      that
        .FnWebAPIPost(param)
        .then(function (res) {
          if (res.data.result) {
            that.FnNotify("初始化成功", "success");
            that.searsh_list();
            that.reset_allowance_info["show"] = false;
          } else {
            that.FnNotify(`初始化失敗: ${res.data.message}`, "error");
            that.searsh_list();
            that.reset_allowance_info["show"] = true;
          }
        })
        .catch(function (err) {
          that.$q.loading.hide();
          console.log(err);
        });
    },
  },
};
