var page_function = {
  data: () => {
    return {
      // 覆蓋base_function內的設置
      LoginSetup: {
        required: false,
      },
      account: "",
      password: "",
    };
  },
  mounted() {},
  methods: {
    fnToLogin() {
      if (!this.account.length || !this.password.length) {
        return false;
      }

      var self = this;
      var params = new FormData();
      params.append("user", self.account);
      params.append("pwd", self.password);
      // == 保留需要用到的 SessionStorage ==
      let storageList = [
        "$$locale", // 語系
        "$$redirect", // 登入後要導向的頁面(先不刪,再轉換前再刪)
      ];
      let allStorage = _.keys(this.$q.sessionStorage.get.all());
      _.each(allStorage, (itmName) => {
        if (
          _.findIndex(storageList, (k) => {
            return itmName == k;
          }) < 0
        ) {
          this.$q.sessionStorage.remove(itmName);
          console.log("remove session storage: " + itmName);
        }
      });
      // == /保留需要到的 SessionStorage ==
      /*
			// == 刪除上次操作用不到的 SessionStorage ==
			let storageList = [
				"$$select_station", // 右選單的選擇案場
				"$$select_city", // 右選單的選擇縣市
				"$$url_param_*", // url params 含萬用字元
			];
			// 刪除不含萬用字元的 SessionStorage
			_.each(storageList, (itmName) => {
				if (!itmName.endsWith("*")) {
					this.$q.sessionStorage.remove(itmName);
				}
			});
			// 刪除含萬用字元的 SessionStorage
			let allStorage = _.keys(this.$q.sessionStorage.get.all());
			let storageWildcard = _.filter(storageList, (itmName) => {
				return itmName.endsWith("*");
			});
			_.each(allStorage, (itmName) => {
				if (_.findIndex(storageWildcard, (k) => {
					k = k.replace("*", "");
					return itmName.startsWith(k);
				}) >= 0) {
					this.$q.sessionStorage.remove(itmName);
				}
			});
			*/
      // == /刪除上次操作用不到的 SessionStorage ==

      axios
        .post(self.ActionUrl.login, params)
        .then((res) => {
          self.WebStorage.set("sunware_token", res.data.token);
          let redirect = self.$q.sessionStorage.get.item("$$redirect"); // 因為 ?redirect=xxx.php?yyy=1&bbb=2 會在 login.js中將 redirect=xxx.php?yyy=1, bbb=2 故改用 sessionStorage
          if (redirect != null && redirect != "") {
            this.$q.sessionStorage.set("$$is_login_redirect", true);
            this.$q.sessionStorage.remove("$$redirect");
            self.FnPageSwitch(redirect);
          } else {
            self.FnPageSwitch("index.php");
          }
        })
        .catch(async function (err) {
          var message = self.$t("sys.plz_try_again") + " (-1)";
          if (err.code == "ECONNABORTED") {
            // axios timeout response code
            message = self.$t("sys.plz_try_again") + " (0)";
          } else if (typeof err.response != "undefined") {
            message =
              err.response.status == "401"
                ? self.$t("page.login.verify_failed")
                : self.$t("page.sys.plz_try_again") +
                  " (" +
                  err.response.status +
                  ")";
          }
          await self.FnAlert(self.$t("page.login.login_failed"), message);
        });

      return false;
    },
  },
};
