var $$mixins_layout = {
  components: {
    "main-menu": httpVueLoader("components/layout/main_menu.vue"),
    "right-menu-station": httpVueLoader("components/layout/right_menu_station.vue"),
    "nav-menu": httpVueLoader("components/layout/nav_menu.vue"),
    "lang-menu": httpVueLoader("components/layout/lang_menu.vue"),
    "more-menu": httpVueLoader("components/layout/more_menu.vue"),
    "alarm-bell": httpVueLoader("components/layout/alarm_bell.vue"),
    "change-password": httpVueLoader("components/layout/change_password.vue"),
	"header-menu": httpVueLoader("components/layout/header_menu.vue"),
  },
  data () {
    return {
      "VarMenu": "shopee", // 使用哪一個 menu 預設 area
      "VarMenuIsOverlay": false,
      "VarIsRightMenu": false, // 是否啟用右側選單
      "VarIsRightMenuOpen": false, // 右側選單是否開啟(案場選單)
      "VarIsDesktop": false,
      "VarIsMobile": false,
      "VarIsTablet": false,
      "VarLayoutScreenWidth": 0,
      "VarLayoutScreenHeight": 0,
      "VarLayoutContainerWidth": 0,
      "VarLayoutContainerHeight": 0,
      "VarScreenIsVertical": false, // 是否垂直螢幕
      "VarIsIPhone": false,
      "VarIsIPad": false,
      "VarIsIOS": false,
      "VarIsAndroid": false,
      "VarIsChrome": false,
      "VarPlatform": "", // win,android,iphone,ipad(surface pro 會判定為 ipad)
      "VarPageContainerCss": "padding:20px 20px;", // <q-page-container><div :style="VarPageContainerCss"></div>
    }
  },
  computed: {
    VarIsMenuOpen () { // 選單是否開啟(連動 MenuSetup.opened)
      return this.MenuSetup.opened;
    }
  },
  methods: {
    fnOnScreenResize (opts) {
      this.VarIsDesktop = this.$q.platform.is.desktop || false;
      this.VarIsIPhone = this.$q.platform.is.iphone || false;
      this.VarIsIPad = this.$q.platform.is.ipad || false;
      this.VarIsIOS = this.$q.platform.is.ios || false;
      this.VarIsAndroid = this.$q.platform.is.android || false;
      this.VarIsChrome = this.$q.platform.is.chrome || false; // 還沒試過 ios 系統(利用 chrome dev tools測試, 沒有值)
      this.VarPlatform = this.$q.platform.is.platform;
      this.VarScreenIsVertical = opts.height > opts.width;
      this.VarLayoutScreenWidth = opts.width;
      this.VarLayoutScreenHeight = opts.height;
      if (this.$q.platform.is.mobile) {
        if (this.VarPlatform == "iphone") {
          this.VarIsMobile = true;
        } else {
          if (this.VarLayoutScreenWidth < 768) { // 寬度<768就是手機
            this.VarIsMobile = true;
          } else if (this.VarLayoutScreenWidth < 992 || this.VarPlatform == "ipad" || this.VarPlatform == "android") { // 寬度<992 & >768就是平板
            this.VarIsTablet = true;
          }
        }
      }
      try {
        this.OnScreenResize(opts);
      } catch (e) { }
    },
    fnOnContainerResize (opts) {
      this.VarLayoutContainerWidth = opts.width;
      this.VarLayoutContainerHeight = opts.height;
      try {
        this.OnContainerResize(opts);
      } catch (e) { }
    },
    OnScreenResize () { }, // 螢幕長寬變更, 供各網頁覆寫用
    OnContainerResize () { }, // 內容區域變更, 供各網頁覆寫用
  }
}